import requests


class Conductor:
    _HOSTS_URL_TPL = '{conductor_url}/{host_group_name}'

    def __init__(self, url):
        self._url = url

    def get_hosts(self, host_group_name):
        """
        return list of hosts in host_group_name
        """
        request_url = self._HOSTS_URL_TPL.format(conductor_url=self._url, host_group_name=host_group_name)

        try:
            response = requests.get(url=request_url, verify=False)
        except Exception as e:
            raise RuntimeError('Unable to get list of hosts: {reason}'.format(reason=e.message))

        # response consists of src_names one per line
        return response.content.splitlines()
