from contextlib import contextmanager
import logging
import os
import tempfile


logger = logging.getLogger(__name__)


# Create temporary file and close it
# so it can be safely explicitely opened when needed.
# See https://stackoverflow.com/questions/56135188/tempfile-temporaryfile-seems-empty-even-though-its-not for details.
@contextmanager
def create_tempfile(**options):
    tmp_file = tempfile.NamedTemporaryFile(delete=False, **options)
    try:
        tmp_file.close()
        yield tmp_file.name
    finally:
        os.unlink(tmp_file.name)
