import signal
from contextlib import contextmanager


def raise_timeout(signum, frame):
    raise RuntimeError('Timeout reached')


@contextmanager
def timeout(time):
    signal.signal(signal.SIGALRM, raise_timeout)
    if time is not None:
        signal.alarm(time)
    try:
        yield
    finally:
        signal.signal(signal.SIGALRM, signal.SIG_IGN)
