# coding: utf-8
import sandbox.projects.resource_types.releasers as resource_releasers
from sandbox import sdk2


class PORTO_LAYER_STRM_STREAM(sdk2.Resource):
    """A Porto layer for STRM stream proxy"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class PORTO_LAYER_STRM_PLAYLISTS(sdk2.Resource):
    """A Porto layer for STRM playlists"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class PORTO_LAYER_STRM_FRONT(sdk2.Resource):
    """A Porto layer for STRM playlists"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class PORTO_LAYER_STRM_TRNS(sdk2.Resource):
    """A Porto layer for STRM trns, fat packages"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class PORTO_LAYER_STRM_TRNS_SMALL(sdk2.Resource):
    """A Porto layer for STRM trns, small packages"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class PORTO_LAYER_STRM_LOGSHATTER(sdk2.Resource):
    """A Porto layer for STRM logshatter"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class PORTO_LAYER_STRM_UBUNTU_XENIAL(sdk2.Resource):
    """Base STRM ubuntu xenial porto layer"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class PORTO_LAYER_STRM_UBUNTU_BIONIC(sdk2.Resource):
    """Base STRM ubuntu bionic porto layer"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class PORTO_LAYER_STRM_UBUNTU_BIONIC_STREAM_SALT(sdk2.Resource):
    """A Porto layer for STRM stream services managed by salt-minion"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_LOGSHATTER_APP(sdk2.Resource):
    """STRM Logshatter app"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_LOGSHATTER_CONFIGS(sdk2.Resource):
    """Configs for STRM Logshatter"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_CLICKPHITE_CONFIGS(sdk2.Resource):
    """Configs for STRM Clickphite"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_STREAM_PLAYLISTS_CONFIGS(sdk2.Resource):
    """Configs for STRM playlists"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_PLGO_CONFIGS(sdk2.Resource):
    """Configs for STRM playlists"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_PLAYLIST_CACHE_CONFIGS(sdk2.Resource):
    """Configs for STRM playlist cache nginx config"""

    calc_md5 = True
    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_STREAM_DEFAULT_CONFIGS(sdk2.Resource):
    """Configs for STRM stream default proxy"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_STREAM_INTERNAL_EDGE_CONFIGS(sdk2.Resource):
    """Configs for STRM stream internal edge proxy"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_STREAM_COLD_EDGE_CONFIGS(sdk2.Resource):
    """Configs for STRM stream internal edge proxy"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_STREAM_ANYCAST_NET_CONFIGS(sdk2.Resource):
    """Configs for STRM anycast strm.yandex.net proxy"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_VAST_CONVERTER(sdk2.Resource):
    """vast-converter for STRM"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_PLAYLIST_GENERATOR(sdk2.Resource):
    """playlist-generator for STRM"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_CHANNEL_TUMBLER(sdk2.Resource):
    """channel-tumbler for STRM"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_CHANNEL_TUMBLER_NGINX_CONFIGS(sdk2.Resource):
    """STRM nginx configs for channel-tumbler"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_CHANNEL_TUMBLER_JUGGLER_CHECKS_BUNDLE(sdk2.Resource):
    """STRM juggler checks for channel-tumbler"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_HARRIER(sdk2.Resource):
    """STRM online har viewer"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_PERF(sdk2.Resource):
    """STRM perf https://github.yandex-team.ru/strm/strm-perf"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_PLGO(sdk2.Resource):
    """playlist-generator written in GO"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_PLAYLIST_JSON(sdk2.Resource):
    """playlist-generator-json"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_GOGOL(sdk2.Resource):
    """Universal /log handler written in Go"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_NGINX_BINARY(sdk2.Resource):
    """STRM nginx arcadia://nginx/bin"""

    deprecated = True
    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_NGINX_BINARY_XENIAL(sdk2.Resource):
    """STRM nginx arcadia://nginx/bin, build for xenial"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_NGINX_BINARY_BIONIC(sdk2.Resource):
    """STRM nginx arcadia://nginx/bin, build for bionic"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_NGINX_COMMON_CONFIG(sdk2.Resource):
    """STRM nginx common config"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class JPEGTRAN_BINARY(sdk2.Resource):
    """BINARY FOR JPEGTRAN UTILITY"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_GORSHOK(sdk2.Resource):
    """Content manager written in Go"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_XACCELREDIRECT(sdk2.Resource):
    """XAccelRedirect written in Go"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_XACCELREDIRECT_CONFIGS(sdk2.Resource):
    """Configs for XAccelRedirect"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_VAGON(sdk2.Resource):
    """Transport chunks, thunmbnails and sprites to s3"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_DASHBOARD(sdk2.Resource):
    """Dashboard for TV channels"""

    releasable = True
    releasers = resource_releasers.strm_releasers + resource_releasers.strm_tools_releasers


class STRM_UGC_DASHBOARD(sdk2.Resource):
    """Dashboard for live streams"""

    releasable = True
    releasers = resource_releasers.strm_releasers + resource_releasers.strm_tools_releasers


class STRM_UGC_DASHBOARD_TESTING(STRM_UGC_DASHBOARD):
    """Dashboard for live streams (testing)"""


class STRM_LINK_VIEW(sdk2.Resource):
    """Dashboard for TV channels"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_TRANSCODER(sdk2.Resource):
    """Media Stream Transcoder"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_TRANSCODER_CUDA_10_1(sdk2.Resource):
    """Media Stream Transcoder with cuda 10.1"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_CV_ADCV2_DATA(sdk2.Resource):
    """adcv2 data for ffmpeg-adcv"""

    auto_backup = True


class STRM_CV_SUPRES_DATA(sdk2.Resource):
    """supres data for ffmpeg-adcv"""

    auto_backup = True


class STRM_FFMPEG_ADCV_COMMON(sdk2.Resource):
    """ffmpeg_adcv -- release common, without tensorflow"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_FFMPEG_ADCV_CUDA10(sdk2.Resource):
    """ffmpeg_adcv -- release CUDA=10, with tensorflow"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_PULT_API(sdk2.Resource):
    """A service for generating live channel configurations in STRM based on changes in the CMS (only API)"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_PULT_BACKEND(sdk2.Resource):
    """A service for generating live channel configurations in STRM based on changes in the CMS (API + Scheduler)"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_PULT_TRNS_SALT_AGENT(sdk2.Resource):
    """Agent to call salt on changes from pult api"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_PINGER(sdk2.Resource):
    """A service for pinging external hosts"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_TRNS_MANAGER(sdk2.Resource):
    """Strm trns manager"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_TRNS_MGR_NGINX_CONFIGS(sdk2.Resource):
    """Configs for STRM trns-manager nginx"""

    calc_md5 = True
    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_CHUNKS_EATER(sdk2.Resource):
    """Strm (bad) chunks eater"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_CDN2TSKV(sdk2.Resource):
    """Strm converter for cdn logs to tskv format"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_TRNS_AGENT(sdk2.Resource):
    """Strm trns agent"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_VYBRATOR(sdk2.Resource):
    """Strm vybrator"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_YOUBER_TRNS_MANAGER(sdk2.Resource):
    """Strm youber-trns-manager - control plane for live streaming"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_NGINX_GENERATE_CLOUD_CONFIGS(sdk2.Resource):
    """Strm tool for generating various configs for nginx in cloud"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_STREAMCMP(sdk2.Resource):
    """STRM stream compare tool"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_TRNS_MANAGER_FORCE_SLAVE(sdk2.Resource):
    """STRM tool to switch to diferrent trns on stop"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_PONGER(sdk2.Resource):
    """STRM Ponger"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_CDNBALANCER(sdk2.Resource):
    """STRM CDNBalancer, TODO: remove"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_CACTO(sdk2.Resource):
    """STRM Cacto"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_CLICKHOUSE_DICTIONARY_API(sdk2.Resource):
    """STRM ClickHouse Dictionary API"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_GOMSR(sdk2.Resource):
    """STRM gomsr"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_CONTENT_TOP(sdk2.Resource):
    """STRM content-top"""

    releasable = True
    releasers = resource_releasers.strm_releasers


class STRM_SALT_STATES(sdk2.Resource):
    """STRM roots and pillars"""

    releasable = True
    releasers = resource_releasers.strm_releasers

