# This script will be executed before most of "host" bindings like `/dev` or `/proc` will be unmounted
# but after all the packages installed

# SANDBOX-5947: forcibly set GMT+3 timezone
echo "Europe/Moscow" > /etc/timezone
rm /etc/localtime
dpkg-reconfigure -f noninteractive tzdata

rm -f /etc/sudoers.d/yandex-search || true
mkdir -m 0700 /root/.ssh/ || true

#groupadd -g 3831 sandbox
#useradd --uid 3831 --gid 3831 --create-home --home-dir /home/sandbox sandbox -s /bin/bash
#groupadd -g 29684 zomb-sandbox
#useradd --uid 29684 --gid 29684 --create-home --home-dir /home/zomb-sandbox zomb-sandbox -s /bin/bash
# Ensure kvm and fuse groups exists and `sandbox` user is a member of them
#addgroup --system kvm
#usermod -aG kvm sandbox
#addgroup --system fuse
#usermod -aG fuse sandbox

#ln -s /opt/skynet/supervisor/base/active /skynet
#[ $(getent group skynet) ] || groupadd -g 1044 skynet
#[ $(getent passwd skynet) ] || useradd --uid 1044 --gid 1044 --home-dir /skynet skynet -s /bin/sh
#usermod -a -G sandbox zomb-sandbox
#install -d /opt/sandbox/run -o sandbox -g sandbox -m 0775
#install -d /place/sandbox-data -o sandbox -g sandbox -m 0775
#install -d /var/log/sandbox -o sandbox -g sandbox -m 0775
install -d /lib -o root -g root -m 0755  # SANDBOX-6629
#install -d /place/vartmp -o root -g root -m 1777
#install -d /place/berkanavt/supervisor -o root -g root -m 0755
#install -d /place/coredumps -o root -g root -m 1755
#chmod 0755 /place

# Move all content of /Berkanavt to /place/berkanavt if directory already exists.
#if [ ! -L /Berkanavt ] && [ -d /Berkanavt ] && [ -d /place/berkanavt ]; then mv /Berkanavt/* /place/berkanavt; rm -rf /Berkanavt; fi
#ln -sf /place/berkanavt /Berkanavt

#ln -sf /place/coredumps /coredumps
#ln -s /skynet/tools/sky /usr/local/bin/sky

echo "KERNEL==\"kvm\", GROUP=\"kvm\", MODE=\"0660\"" > /etc/udev/rules.d/80-kvm.rules
chmod 0644 /etc/udev/rules.d/80-kvm.rules
echo "KERNEL==\"fuse\", GROUP=\"fuse\", MODE=\"0666\"" > /etc/udev/rules.d/80-fuse.rules
chmod 0644 /etc/udev/rules.d/80-fuse.rules

apt-get update
apt-get install --no-install-recommends --no-install-suggests --assume-yes yandex-cauth-userd=2.0-8959219

# Install certificates
# YandexInternalRootCA certificate
# Install Intermediate SSL-certificate
mkdir -p /usr/local/share/ca-certificates/;
curl https://crls.yandex.net/YandexInternalRootCA.crt > /usr/local/share/ca-certificates/YandexInternalRootCA.crt;
curl https://crls.yandex.net/allCAs.pem > /etc/ssl/certs/allCAs.pem;
curl https://crls.yandex.net/allCAs.pem >> /etc/ssl/certs/ca-certificates.crt;

update-ca-certificates;

# Setup Europe/Moscow as the default timezone
echo 'Europe/Moscow' > /etc/timezone;
[ -s /usr/share/zoneinfo/Europe/Moscow ] && ln -fs /usr/share/zoneinfo/Europe/Moscow /etc/localtime;
if [ -L /usr/share/zoneinfo/UTC ] && [ -f /usr/share/zoneinfo/Etc/UTC ]; then ln -fs /usr/share/zoneinfo/Etc/UTC /usr/share/zoneinfo/UTC; fi;
dpkg-reconfigure --frontend noninteractive tzdata;

# Generate the en_US.UTF-8 locale
locale-gen en_US.UTF-8;

# enable pkgver-systemd.service
/bin/systemctl enable pkgver-systemd.service

# cleanup sky
#rm -rf /place /Berkanavt /coredumps /skynet /opt/*
dpkg -r yandex-gosky || :
