import os
import logging
import json
import os.path

import sandbox.sandboxsdk.environments as sdk_environments

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.common.errors import TaskFailure

from sandbox.projects.SuggestTestSecond import utils


class PrepareResourceShard(sdk2.Resource):
    releasers = ['temnajab', ]
    releasable = True
    any_arch = True


class SuggestBuildShard(sdk2.Task):
    """ build suggest shard """

    class Requirements(sdk2.Requirements):
        environments = [sdk_environments.PipEnvironment('yandex-yt'), ]
        disk_space = 256 * 1024  # 256Gb
        ram = 128 * 1024         # 128Gb

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 6 * 60 * 60  # 6 hours
        part = sdk2.parameters.Integer("part number")
        rec_from = sdk2.parameters.Integer("from record")
        rec_to = sdk2.parameters.Integer("to record")
        prepare_files = sdk2.parameters.Integer("prepare_files resource id")
        shard_files = sdk2.parameters.Integer("build shard resource")
        geodata_id = sdk2.parameters.Integer("geodata")
        yt_token_temnajab = sdk2.parameters.String("yt_token_temnajab")
        table_prefix = sdk2.parameters.String("table_prefix")

        with sdk2.parameters.Output:
            shard_resouce_ext = sdk2.parameters.String(
                "shard resource ext", required=True
            )

    def on_execute(self):
        logging.info('start SuggestBuildShard')

        logging.info('geodata process')
        utils.download_sandbox_resource(self.Parameters.geodata_id)

        logging.info('download sandbox resource: %id', self.Parameters.prepare_files)
        utils.download_sandbox_resource(self.Parameters.prepare_files)
        logging.info('download build shard files: %id', self.Parameters.shard_files)
        utils.download_sandbox_resource(self.Parameters.shard_files)

        logging.info('checkout files from svn')
        path_suggest_framework = utils.checkout_from_svn(
            'suggest_framework',
            'arcadia/quality/trailer/suggest_dict/suggest_framework'
        )

        logging.info('checkout shards scripts')
        path_shards_scripts = utils.checkout_from_svn(
            'shards_scripts',
            'arcadia/quality/trailer/suggest_dict/tools/bigdata/scripts'
        )

        # for c in range(60):
        #     logging.info('STARTING')
        #     time.sleep(1)

        build_error = False
        desc = []
        with sdk2.helpers.ProcessLog(self, logger="build_shard") as pl:
            strrun = " ".join((
                path_shards_scripts + '/build_shard.sh',
                str(self.Parameters.rec_from),
                str(self.Parameters.rec_to),
                'geodata5.bin',
                sdk2.Vault.data(self.Parameters.yt_token_temnajab),
                self.Parameters.table_prefix,
                path_suggest_framework,
            ))

            logging.info('call: %s', strrun)
            sp.Popen(strrun, shell=True, stdout=pl.stdout, stderr=sp.STDOUT
                     ).wait()

            for f in ['bindata.porno.src.trie.txt', 'bindata.porno.trie', 'bindata.prefixindex', 'bindata.queries', 'bindata.serps', 'bindata.trie', 'bindata.wordindex']:
                if not os.path.exists('./dat/' + f):
                    build_error = True
                    desc.append('not file ' + f + ' for shard ' + str(self.Parameters.part))

            if not build_error:
                for f in ['bindata.prefixindex', 'bindata.queries', 'bindata.serps', 'bindata.trie', 'bindata.wordindex']:
                    statinfo = os.stat('./dat/' + f)
                    if statinfo.st_size == 0:
                        build_error = True
                        desc.append('file ' + f + ' for shard ' + str(self.Parameters.part) + ' is empty')

        jsonObj = None
        if build_error:
            jsonObj = {}
            jsonObj['status'] = 'fail'
            jsonObj['desc'] = ','.join(desc)
            raise TaskFailure('failed build shard')
        else:
            with open('./report.meta') as f:
                jsonObj = json.load(f)
            jsonObj['status'] = 'ok'

            desc = 'shard number ' + str(self.Parameters.part)
            path = 'dat'
            resource = PrepareResourceShard(self, desc, path)
            resource.ttl = 30
            data = sdk2.ResourceData(resource)
            data.ready()

            logging.info('shard number: %i id: %i', self.Parameters.part, resource.id)
            jsonObj['shard'] = resource.id
        self.Parameters.shard_resouce_ext = json.dumps(jsonObj)
