import os
import logging
import subprocess
import requests
import json
import os.path

from sandbox import sdk2
import sandbox.common.share as c_share


def sky_files(rbtorrent):
    files = subprocess.check_output(['sky', 'files', '--json', rbtorrent])
    return json.loads(files)


def sky_get_like_iss(url, destination):
    logging.info('download rbtorrent %s into %s', url, destination)
    torrent_files = sky_files(url)
    # if rbtorrent has a directory then there is will be additional element in torrent_files.
    # So if len=1 then there is only one file without directory
    if len(torrent_files) == 1 and '/' not in torrent_files[0]['name']:
        c_share.skynet_get(url, '.')
        os.rename(torrent_files[0]['name'], destination)
    else:
        c_share.skynet_get(url, destination)


def download_sandbox_resource(resource_id, local_path=''):
    logging.info('download_sandbox_resource(%s, %s)', resource_id, local_path)
    resource_tmp = requests.get('https://sandbox.yandex-team.ru:443/api/v1.0/resource/{}'.format(resource_id))
    logging.info('resoruce %s', str(resource_tmp))
    resource = resource_tmp.json()
    if not local_path:
        local_path = os.path.basename(resource['file_name'])
    sky_get_like_iss(resource['skynet_id'], local_path)


def checkout_from_svn(desc, path):
    logging.info('checkout: %s', desc)
    full_path = 'arcadia:/arc/trunk/' + path
    res = sdk2.svn.Arcadia.get_arcadia_src_dir(full_path)
    cwd_files = ' '.join(os.listdir(res))
    logging.info('svn checkout info')
    logging.info('name: %s', desc)
    logging.info('localpath: %s', res)
    logging.info('arcadia path: %s', full_path)
    logging.info('files: %s', cwd_files)
    return res
