# -*- coding: utf-8 -*-
from os.path import join as join_path, realpath, dirname

from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk import errors
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import task
from sandbox.sandboxsdk.process import run_process, check_process_return_code

DEFAULT_QUERY = """
USE hahn;
PRAGMA inferscheme;

$quote_udf = Python::quote("(String)->String",
@@
import json
def quote(name):
    return json.dumps(name)
@@);

$active = (SELECT DISTINCT(install_id) as install_id FROM (
    SELECT
        FIRST_VALUE(install_id) IGNORE NULLS OVER w as install_id
    FROM [%src%/registrations]
    WINDOW w AS (
        PARTITION BY app_id, hardware_id
        ORDER BY updated_at DESC
    )
));

$regpart = (
SELECT
'"registration": { '
||       '"updatedAt" : { "$date" : "' || (DateTime::ToString(DateTime::FromString(updated_at)) ?? '') || '"}, '
||       CASE WHEN LENGTH(push_token) = 0 THEN '' ELSE '"pushToken" : ' || $quote_udf(push_token ?? '') || ', ' END
||       CASE WHEN LENGTH(device_id) = 0 THEN '' ELSE '"deviceId" : ' || String::RemoveAll($quote_udf(device_id ?? ''), '-') || ', ' END
||       CASE WHEN LENGTH(hardware_id) = 0 THEN '' ELSE '"hardwareId" : ' || $quote_udf(hardware_id ?? '') || ', ' END
||       CASE WHEN LENGTH(notify_disabled_reason) = 0 THEN '' ELSE '"notifyDisabledReason" : ' || $quote_udf(notify_disabled_reason ?? '') || ', ' END
||       '"notifyDisabled" : ' || (CASE WHEN (notify_disabled ?? 'f') = 't' THEN 'true' ELSE 'false' END)
||   '}' AS registration_json,
'"installId" : ' || String::RemoveAll($quote_udf(rp.install_id ?? ''), '-') AS install_id_json,
ListFilter(AsList(
  CASE WHEN LENGTH(app_id) = 0 THEN '' ELSE '"app_id": ' || $quote_udf(app_id ?? '') END,
  CASE WHEN LENGTH(platform) = 0 THEN '' ELSE '"platform": ' || $quote_udf(platform ?? '')  END,
  CASE WHEN LENGTH(hardware_id) = 0 THEN '' ELSE '"app_version": ' || $quote_udf(app_version ?? '') END,
  CASE WHEN LENGTH(app_version) = 0 THEN '' ELSE '"device_name": ' || $quote_udf(device_name ?? '')  END,
  CASE WHEN LENGTH(zone_id) = 0 THEN '' ELSE '"zone_id": ' || $quote_udf(zone_id ?? '')  END
), '!=', '') AS tags_json,
rp.install_id
FROM [%src%/registrations] as rp
);

$tagpart = (
SELECT ListFilter(AsList(
  CASE WHEN LENGTH(tag_value_0) = 0 THEN '' ELSE '"geo_3": ' || $quote_udf(tag_value_0 ?? '')  END,
  CASE WHEN LENGTH(tag_value_1) = 0 THEN '' ELSE '"geo_4": ' || $quote_udf(tag_value_1 ?? '')  END,
  CASE WHEN LENGTH(tag_value_2) = 0 THEN '' ELSE '"geo_5": ' || $quote_udf(tag_value_2 ?? '')  END,
  CASE WHEN LENGTH(tag_value_3) = 0 THEN '' ELSE '"geo_6": ' || $quote_udf(tag_value_3 ?? '')  END,
  CASE WHEN LENGTH(tag_value_4) = 0 THEN '' ELSE '"has_yandex_metro_app": ' || $quote_udf(tag_value_4 ?? '')  END,
  CASE WHEN LENGTH(tag_value_5) = 0 THEN '' ELSE '"has_yandex_weather_app": ' || $quote_udf(tag_value_5 ?? '') END,
  CASE WHEN LENGTH(tag_value_6) = 0 THEN '' ELSE '"yandex_staff": ' || $quote_udf(tag_value_6 ?? '') END,
  CASE WHEN LENGTH(tag_value_7) = 0 THEN '' ELSE '"weatherTileId": ' || $quote_udf(tag_value_7 ?? '') END,
  CASE WHEN LENGTH(tag_value_8) = 0 THEN '' ELSE '"locale": ' || $quote_udf(tag_value_8 ?? '') END,
  CASE WHEN LENGTH(tag_value_9) = 0 THEN '' ELSE '"lang": ' || $quote_udf(tag_value_9 ?? '') END,
  CASE WHEN LENGTH(tag_value_10) = 0 THEN '' ELSE '"country": ' || $quote_udf(tag_value_10 ?? '') END,
  CASE WHEN LENGTH(tag_value_11) = 0 THEN '' ELSE '"app_version_code": ' || $quote_udf(tag_value_11 ?? '') END
), '!=', '') AS tags_json,
install_id
FROM [%src%/tags]
);

$loginpart = (
SELECT
'"user": { '
||  '"isLoggedIn" : '|| (CASE WHEN (is_logged_in ?? 'f') = 't' THEN 'true' ELSE 'false' END) || ', '
||  CASE WHEN LENGTH(uid) = 0 THEN '' ELSE '"uid" : ' || $quote_udf(uid ?? '') || ', ' END
||  CASE WHEN LENGTH(login) = 0 THEN '' ELSE '"login" : '|| $quote_udf(login ?? '') || ', ' END
||  '"updatedAt" : { "$date" : "' || (DateTime::ToString(DateTime::FromString(updated_at)) ?? '') || '" }'
||   '}' AS user_json,
install_id
FROM [%src%/logins]
);

$subscr = (
SELECT
'"subscriptions": [ '
||  String::JoinFromList(LIST(
    '{ "project" : ' || $quote_udf(project_id ?? '') || ', '
||  '"topic" : '|| $quote_udf(topic ?? '') || ', '
||  '"ttl" : '|| (ttl ?? '-1') || ', '
||  '"updatedAt" : { "$date" : "' || (DateTime::ToString(DateTime::FromString(updated_at)) ?? '') || '" } }'
), ',')
|| ' ]' AS subscriptions_json,
install_id
FROM [%src%/subscriptions]
GROUP BY install_id
);

COMMIT;

INSERT INTO [%dst%/combined] WITH TRUNCATE
SELECT rp.install_id AS install_id, '{ '
|| rp.install_id_json
|| ', ' || rp.registration_json
|| ', "tags": { ' || String::JoinFromList(ListExtend(rp.tags_json, tp.tags_json ?? ListCreate('String')), ',') || ' }'
|| (CASE WHEN lp.user_json IS NULL THEN '' ELSE (', ' || (lp.user_json ?? '')) END)
|| (CASE WHEN sp.subscriptions_json IS NULL THEN '' ELSE (', ' || (sp.subscriptions_json ?? '')) END)
|| ' }' AS json
FROM $regpart AS rp
INNER JOIN $active as a ON a.install_id=rp.install_id
LEFT JOIN $tagpart AS tp ON rp.install_id = tp.install_id
LEFT JOIN $loginpart AS lp ON rp.install_id = lp.install_id
LEFT JOIN $subscr AS sp ON rp.install_id = sp.install_id
ORDER BY install_id;

COMMIT;

INSERT INTO [%dst%/combined_0] WITH TRUNCATE
SELECT * FROM [%dst%/combined]
LIMIT 7000000 OFFSET 0;

INSERT INTO [%dst%/combined_1] WITH TRUNCATE
SELECT * FROM [%dst%/combined]
LIMIT 7000000 OFFSET 7000000;

INSERT INTO [%dst%/combined_2] WITH TRUNCATE
SELECT * FROM [%dst%/combined]
LIMIT 7000000 OFFSET 14000000;

INSERT INTO [%dst%/combined_3] WITH TRUNCATE
SELECT * FROM [%dst%/combined]
LIMIT 7000000 OFFSET 21000000;
"""


class SrcParam(parameters.SandboxStringParameter):
    name = 'src'
    description = 'Src prefix'
    required = True
    default_value = '//home/search-functionality/sup/backup/sup-prod.n.yandex-team.ru/1490739564'


class DstParam(parameters.SandboxStringParameter):
    name = 'dst'
    description = 'Dst prefix'
    required = True
    default_value = '//home/search-functionality/sup/backup/sup-prod.n.yandex-team.ru/1490739564'


class QueryParam(parameters.SandboxStringParameter):
    name = 'query'
    description = 'YQL Query'
    multiline = True
    required = False


class SupBackupCombineTask(task.SandboxTask):
    type = 'SUP_BACKUP_COMBINE'
    input_parameters = [QueryParam, SrcParam, DstParam]

    def on_execute(self):
        token = self.get_vault_data(self.owner, 'robot_sup_yql_token')
        query = self.ctx.get(QueryParam.name).strip() or DEFAULT_QUERY
        dst = self.ctx.get(DstParam.name).strip()
        src = self.ctx.get(SrcParam.name).strip()
        if not token:
            raise errors.SandboxTaskFailureError('Empty token param')
        if not query:
            raise errors.SandboxTaskFailureError('Empty query param')
        query = query.replace('%src%', src)
        query = query.replace('%dst%', dst)
        with environments.VirtualEnvironment() as venv:
            environments.PipEnvironment('yql', venv=venv, use_wheel=False).prepare()
            script_path = join_path(dirname(realpath(__file__)), 'yql_runner.py')
            with open('run.yql', 'w') as q:
                q.write(query)
                q.flush()
            with open('run.yql') as q:
                process = run_process(
                    [venv.executable, script_path, '--token={}'.format(token)], stdin=q, log_prefix='yql', shell=True)
                check_process_return_code(process)


__Task__ = SupBackupCombineTask
