import sys
import argparse
import logging

from yql.api.v1.client import YqlClient

logging.basicConfig(
    level=logging.INFO,
    format='[%(levelname)s %(asctime)s]: %(message)s',
    datefmt='%Y-%m-%d %I:%M:%S'
)


def run(token, query):
    client = YqlClient(token=token)
    query = client.query(query)
    query.run()
    if not query.results.is_success:
        error_description = '\n'.join([str(err) for err in query.results.errors])
        logging.error(error_description)
        return 1
    return 0


def main():
    pars = argparse.ArgumentParser(description="Run yql query")
    pars.add_argument("--query", "-q", help="Query")
    pars.add_argument("--token", "-t", help="Token")
    opts = pars.parse_args()
    query = opts.query if opts.query else sys.stdin.read()
    return run(opts.token, query)


if __name__ == '__main__':
    sys.exit(main())
