# coding: utf-8

"""
FIXME
"""

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

import requests
import json
import time

from datetime import datetime
from sandbox.sandboxsdk import environments as sb_sdk_env
from .yc.objects import ExtendedMetrics

FIRST_LINE_SURVEY = u'Расскажите о ваших впечатлениях от Яндекс.Облака'
FROM_USERS = ['zomb-prj-191', 'robot-yc-support-api']


class StatUploadExceptions(Exception):
    pass


def get_environments():
    return [
        sb_sdk_env.PipEnvironment("startrek_client", version="1.7.0", use_wheel=True)
    ]


def comment_is_survey(comment):
    """
    :param comment: Comment message
    :return  bool:
    """
    if comment is None or not comment.email:
        return False

    return comment.email['subject'].startswith(FIRST_LINE_SURVEY)


def get_delta_time(d1, d2):
    """
    :type d1: float Begin Time
    :type d2: float EndT ime
    :rtype : float diff(end, begin)
    """
    timestamp_d1 = time.mktime(datetime.strptime(d1.split('.')[0], '%Y-%m-%dT%H:%M:%S').timetuple())
    timestamp_d2 = time.mktime(datetime.strptime(d2.split('.')[0], '%Y-%m-%dT%H:%M:%S').timetuple())
    return (timestamp_d2 - timestamp_d1) // 60


def make_simple_date(record, field=None):
    """
    :type record: Startrek Resource - type with *At
    :type field: str or None
    :rtype: str (Unicode) date format YYYY-MM-DD HH:mm:ss
    """
    if field:
        record = record[field]

    timestamp = time.mktime(datetime.strptime(record.split('.')[0], '%Y-%m-%dT%H:%M:%S').timetuple())
    timestamp += 60 * 60 * 3  # shift offset to three hours

    return datetime.fromtimestamp(int(timestamp)).strftime('%Y-%m-%d %H:%M:%S')


def unpack_object(metrics_object):
    if isinstance(metrics_object, list):
        return metrics_object
    else:
        return [metrics_object]


def field_is_exist(issue, field):
    return hasattr(issue, field)


def get_metrics_for_issue(issue):
    """
    :type issue: startrek_client.objects.StartrekIssue
    :return: List<{comment_date: str, time_for_answer: float, comment_author: str, comment_link: str}>
    """
    cnt_try = 0
    metrics_for_issue = {}
    conversations = [issue]  # hack, only for first element!

    for comment in issue.comments.get_all():
        if conversations[-1].createdBy.login in FROM_USERS and comment.createdBy.login not in FROM_USERS:
            if comment_is_survey(comment):
                continue
            try:
                comment.external
            except AttributeError:
                cnt_try += 1

            try:
                if comment.type != 'outgoing':
                    raise AttributeError
            except AttributeError:
                cnt_try += 1

            if cnt_try < 2:
                conversations.append(comment)
            cnt_try = 0  # hack?
        elif conversations[-1].createdBy.login not in FROM_USERS and comment.createdBy.login in FROM_USERS:
            conversations.append(comment)
        elif comment.createdBy.login not in FROM_USERS:
            try:
                if comment_is_survey(comment):
                    continue
                if comment.type == 'outgoing':
                    conversations.append(comment)
            except AttributeError:
                pass

    if len(conversations) == 0:
        return []
    mail_from_user = conversations[0]
    for index in range(1, len(conversations)):
        if conversations[index].createdBy.login in FROM_USERS:
            mail_from_user = conversations[index]
            continue
        metrics_for_issue[make_simple_date(conversations[index].createdAt)] = ExtendedMetrics(
            type_issue=issue.type.key,
            key=issue.key,
            time=get_delta_time(mail_from_user.createdAt, conversations[index].createdAt),
            author=conversations[index].createdBy.id,
            myself='{url}/{key}#{id}'.format(url='https://st.yandex-team.ru', key=issue.key,
                                             id=conversations[index].longId),
            pay_type=issue.pay if field_is_exist(issue, 'pay') else None,
        )

    return metrics_for_issue


def upload_metrics(path_stat, token, metrics, scale='d', suffix=None):
    """
    :type path_stat: str Unicode
    :type token: str Unicode
    :type scale: str Unicode
    :type metrics: Dict<Date: List<MetricsObj>>
    :type suffix: str Unicode with for add to base path
    """
    scaled_metrics = []

    for date in sorted(metrics.keys()):
        for m_obj in unpack_object(metrics[date]):
            scaled_metrics.append({'fielddate': date})
            for field, value in m_obj.__dict__.items():
                if value is not None:
                    scaled_metrics[-1][field] = value

    response = requests.post(
        url='https://stat.yandex-team.ru/_api/report/data',
        headers={'Authorization': 'OAuth {}'.format(token)},
        data={
            'name': path_stat if not suffix else '{}_{}'.format(path_stat, suffix),
            'scale': scale,
            'json_data': json.dumps({'values': scaled_metrics}),
            '_append_mode': 1
        }
    )

    if response.status_code != 200:
        raise StatUploadExceptions(response.text)
