# coding: utf-8

"""
FIXME
"""

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from ..yc.objects import GeneralMetrics
from ..utils import upload_metrics, get_metrics_for_issue, field_is_exist

VIOLATION_TEXT = u'FAIL_CONDITIONS_VIOLATED'


class StorageMetricsExceptions(Exception):
    pass


class StorageMetrics(object):

    @staticmethod
    def is_fail_sla(issue, use_sla_field=False):
        if use_sla_field:
            sla_status = 'violationStatus'
            if field_is_exist(issue, 'sla'):
                field = issue['sla']
                if isinstance(field, list):
                    for state in field:
                        if state[sla_status] == VIOLATION_TEXT:
                            return True
                else:
                    if field[sla_status] == VIOLATION_TEXT:
                        return True
            return False
        else:
            for metric in get_metrics_for_issue(issue).values():
                if metric.time > 480:
                    return True
            return False

    def __init__(self, issues, token, path_statface_report, use_sla=False):
        self._issues_list = issues
        self._token = token
        self._path_statface_report = path_statface_report
        self._use_sla = use_sla

    def _compute_base_metrics(self):
        result = {}

        for date in self._issues_list.keys():
            failed_issues = [issue.key for issue in self._issues_list[date] if self.is_fail_sla(issue, self._use_sla)]
            failed_keys = ', '.join(failed_issues)

            sla_abs_ok = len(self._issues_list[date]) - len(failed_issues)
            sla_abs_fail = len(self._issues_list[date]) - sla_abs_ok
            sla_perc_fail = float(sla_abs_fail) / len(self._issues_list[date]) * 100.0

            result[date] = [
                GeneralMetrics(
                    count_close=len(self._issues_list[date]),
                    sla_absolute_ok=sla_abs_ok,
                    sla_absolute_fail=len(self._issues_list[date]) - sla_abs_ok,
                    sla_percent_fail=sla_perc_fail,
                    failed_issues_keys=failed_keys
                )
            ]

            usernames = set()
            for issue in self._issues_list[date]:
                if 'assignee' in issue.__dict__['_value']:
                    usernames.add(issue.assignee.login)
                elif 'resolvedBy' in issue.__dict__['_value']:
                    usernames.add(issue.resolvedBy.login)

            for username in usernames:
                filtered_issues = [x for x in self._issues_list[date] if ('assignee' in x.__dict__['_value'] and x['assignee'].login == username) or
                                   ('resolvedBy' in x.__dict__['_value'] and x['resolvedBy'].login == username)]

                failed_issues = [issue.key for issue in filtered_issues if self.is_fail_sla(issue, self._use_sla)]

                failed_keys = ', '.join(failed_issues)

                sla_abs_ok = len(filtered_issues) - len(failed_issues)
                sla_abs_fail = len(filtered_issues) - sla_abs_ok
                sla_percent_fail = float(sla_abs_fail) / len(filtered_issues) * 100.0

                result[date].append(GeneralMetrics(
                    user=username,
                    count_close=len(filtered_issues),
                    sla_absolute_ok=sla_abs_ok,
                    sla_absolute_fail=sla_abs_fail,
                    sla_percent_fail=sla_percent_fail,
                    failed_issues_keys=failed_keys,
                    )
                )

        return result

    def _compute_extended_metrics(self):
        """
        :rtype: Will be prepared for seconds-scale!
        """
        result = {}

        for date in self._issues_list.keys():
            for issue in self._issues_list[date]:
                result.update(get_metrics_for_issue(issue))

        return result

    def upload_base(self):
        upload_metrics(
            path_stat=self._path_statface_report,
            token=self._token,
            metrics=self._compute_base_metrics(),
        )

    def upload_extended(self):
        upload_metrics(
            path_stat=self._path_statface_report,
            token=self._token,
            metrics=self._compute_extended_metrics(),
            suffix='extended',
            scale='s'
        )
