import logging

from .common import CPP_FILES, find_patterns_matches, Rule


_BAD_CPP_FUNCTIONS = [
    "getenv",
    "setenv",
    "putenv",
]


def _is_cpp_file(filepath):
    if filepath.endswith(".cpp"):
        return True
    if filepath.endswith(".h"):
        return True


def _is_in_contrib(filepath):
    return filepath.find("contrib/") != -1


def _is_already_have_pattern(file_content_getter, match, rev):
    content = file_content_getter(match.file_name, int(rev) - 1)
    if not content:
        logging.debug("svn error for %s in %d, may be file just added", match.file_name, int(rev) - 1)
        return False

    return match.pattern in content


class BadCppFunctions(Rule):
    message = "Please avoid using low-level functions, use Arcadia wrappers instread"

    def function(self, file_content_getter, diff_context, revision):
        matches_iter = find_patterns_matches(
            file_2_diff=diff_context.file_2_diff,
            file_pattern=CPP_FILES,
            patterns=_BAD_CPP_FUNCTIONS,
        )

        for match in matches_iter:
            if not _is_cpp_file(match.file_name):
                continue
            if _is_in_contrib(match.file_name):
                continue
            if _is_already_have_pattern(file_content_getter, match, revision):
                continue

            return match

        return None
