import logging

from .common import CPP_FILES, find_patterns_matches, Rule


_BAD_HEADERS = [
    "<unistd.h>",
    "<sched.h>",
    "<pthread.h>",
    "<ucontext.h>",
]


class BadHeaders(Rule):
    message = "Should not use these headers in user code."

    def function(self, file_content_getter, diff_context, revision):
        matches_iter = find_patterns_matches(
            file_2_diff=diff_context.file_2_diff,
            file_pattern=CPP_FILES,
            patterns=_BAD_HEADERS,
            to_lower=True,
        )

        for match in matches_iter:
            if match.file_name.startswith('contrib/'):
                # IGNIETFERRO-586
                logging.info("Ignore %s bad headers match in contrib/", match.file_name)
                continue

            return match

        return None
