import base64

from .common import ALL_FILES, find_patterns_single_match, Rule


_NASTY_WORDS_B64 = [
    "bmlnZ2VyCg==",
    "ZnVjawo=",
    "bmlnZ2E=",
]

_NASTY_WORDS = [
    base64.b64decode(nasty_word_b64).strip()
    for nasty_word_b64 in _NASTY_WORDS_B64
]


class NastyWords(Rule):
    message = "Nasty word detected in diff. See https://st.yandex-team.ru/DEVTOOLS-1527."

    def function(self, file_content_getter, diff_context, revision):
        return find_patterns_single_match(
            file_2_diff=diff_context.file_2_diff,
            file_pattern=ALL_FILES,
            patterns=_NASTY_WORDS,
            to_lower=True,
            skip_base64=True,
        )
