import textwrap

from .common import Rule, Match


_YA_MAKE_SUFFIX = '/ya.make'


class NewLibraryDoc(Rule):
    owners = [
        "alexeykruglov",
    ]

    message = textwrap.dedent("""
        New library should have README.md file with project description
        """)

    def function(self, file_content_getter, diff_context, revision):
        for path, status in diff_context.path_2_status.items():
            if not (status == 'A' and path.startswith('library/') and path.endswith(_YA_MAKE_SUFFIX)):
                continue

            path = path[:-len(_YA_MAKE_SUFFIX)]
            readme_path = path + '/README.md'

            if file_content_getter(readme_path, revision - 1):
                continue

            if diff_context.path_2_status.get(readme_path) != 'A':
                return Match(path)
