import textwrap

from .common import Rule, Match


def _get_new_top_level_project_from_diff(diff_context):
    for path, status in diff_context.path_2_status.items():
        if '/' not in path and status == 'A':
            yield path


class NewTopLevelProjectApprove(Rule):
    owners = [
        "alexeykruglov",
    ]

    message = textwrap.dedent("""
        New top level projects in Arcadia should be approved by arcadia-wg

        See https://clubs.at.yandex-team.ru/arcadia/21777 for details.
        """)

    def function(self, file_content_getter, diff_context, revision):
        for path in _get_new_top_level_project_from_diff(diff_context):
            return Match(path)


class NewTopLevelProjectDocumentation(Rule):
    owners = [
        "alexeykruglov",
    ]

    message = textwrap.dedent("""
        New top level projects in Arcadia should have
        1) ya.make file containing OWNER
        2) README.md file with short project description

        See https://clubs.at.yandex-team.ru/arcadia/21777 for details.
        """)

    def function(self, file_content_getter, diff_context, revision):
        for path in _get_new_top_level_project_from_diff(diff_context):
            if diff_context.path_2_status.get(path + '/ya.make') != 'A' or diff_context.path_2_status.get(path + '/README.md') != 'A':
                return Match(path)
            if 'OWNER' not in diff_context.file_2_diff[path + '/ya.make']:
                return Match(path)
