import textwrap

from .common import CPP_FILES, find_patterns_single_match, Rule


class RandomDevice(Rule):
    message = textwrap.dedent("""
        You should not use std::random_device, use Seed() from util/random/entropy.h instead.

        TL;DR
        * std::random_device does not guarantee almost anything about its randomness
        * it may be slow
        * it's bad to initialize PRNG with huge state (e.g. Mersenne Twister) with 32-bit of entropy (return
          value of std::random_device()())

        See https://pg.at.yandex-team.ru/4674 (especially second point).
        """)

    def function(self, file_content_getter, diff_context, revision):
        return find_patterns_single_match(
            file_2_diff=diff_context.file_2_diff,
            file_pattern=CPP_FILES,
            patterns=['random_device'],
        )
