import textwrap

from .common import PY_FILES, find_patterns_matches, Rule


class SandboxSdk(Rule):
    message = textwrap.dedent("""
        You should not use old Sandbox SDK in new tasks, use Sandbox SDK2 instead.

        See https://wiki.yandex-team.ru/sandbox/tasks/sdk2 for details.

        In case of any questions contact with sandbox@yandex-team.ru.
        """)

    def function(self, file_content_getter, diff_context, revision):
        for match in find_patterns_matches(
            file_2_diff=diff_context.file_2_diff,
            file_pattern=PY_FILES,
            patterns=["(SandboxTask)"],
        ):
            if match.file_name.startswith("sandbox/"):
                return match
        return None
