from .BadCppFunctions import BadCppFunctions
from .BadHeaders import BadHeaders
from .DeprecatedLib import DeprecatedLib, MapReduceLibInLibrary, MapReduceClientInLibrary, \
    Search2116
from .NastyWords import NastyWords
from .NewLibraryDoc import NewLibraryDoc
from .NewTopLevelProject import NewTopLevelProjectApprove, NewTopLevelProjectDocumentation
from .Py2Project import Py2Project
from .RandomDevice import RandomDevice
from .SandboxSdk import SandboxSdk


RULES = [
    # generic
    NastyWords(),

    # cpp
    BadCppFunctions(),
    BadHeaders(),
    DeprecatedLib(),
    MapReduceLibInLibrary(),
    MapReduceClientInLibrary(),
    RandomDevice(),
    Search2116(),

    # python
    SandboxSdk(),
    Py2Project(),

    # Arcadia WG
    NewTopLevelProjectApprove(),
    NewTopLevelProjectDocumentation(),

    NewLibraryDoc(),
]

RULES_MAP = {
    rule.name(): rule for rule in RULES
}
