# coding: utf-8

_FILE_NAME_DIFF_PREFIX = 'Index: '


class DiffContext(object):
    def __init__(self, file_2_diff, path_2_status):
        self.file_2_diff = file_2_diff
        self.path_2_status = path_2_status


def parse_diff(diff, diff_summary):
    file_2_diff = {}
    path_2_status = {}

    current_file = None

    for line in diff.split('\n'):
        if line.startswith(_FILE_NAME_DIFF_PREFIX):
            current_file = line[len(_FILE_NAME_DIFF_PREFIX):]
            file_2_diff[current_file] = line
        elif current_file:
            file_2_diff[current_file] += '\n' + line

    for line in diff_summary.split('\n'):
        if not line:
            continue
        parts = line.split('svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/')
        assert len(parts) == 2
        path_2_status[parts[1].strip()] = parts[0].strip()

    return DiffContext(file_2_diff, path_2_status)
