import sys

from sandbox.projects.SuspiciousCommits import rules
from sandbox.projects.SuspiciousCommits.rules import diff_parse


def main():
    # TODO(mvel): argparse
    if len(sys.argv) < 2:
        print('Usage: cat <patch.diff> | {} <rule_name>'.format(sys.argv[0]))
        sys.exit(2)

    rule_name = sys.argv[1]
    diff = sys.stdin.read()
    file_2_diff = diff_parse.parse_diff(diff)
    rule = rules.RULES_MAP[rule_name]
    match = rule.function(diff, file_2_diff, [])
    if match:
        print("Rule `{}` matches the diff".format(rule_name))
        sys.exit(0)

    # be like grep
    sys.exit(1)


if __name__ == '__main__':
    main()
