# -*- coding: utf-8 -*-

import logging

from sandbox.projects.VideoDBAccept import VideoAccept
from sandbox.projects.common import apihelpers
from sandbox.projects.MediaLib.SwitchMediaDatabase import (
    SwitchMediaDatabase, ShardmapName, SwitchDashboardName, SwitchDashboardRecipe,
    ZkFlags, ShardmapTaskToDeploy, NewDBDashboardName
)
from sandbox.projects.MediaLib.shardmap import Shardmap
from sandbox.projects import resource_types


SWITCH_DASHBOARD_NAME = 'video_base'
NEWDB_DASHBOARD_NAME = 'video_newdb'

DATABASE_SWTICH_RECIPE = 'deploy_video_database'
ZK_FLAGS = {
    'newdb': '/media-services/video/flags/newdb_video_sbase/on_production',
    'on_production': '/media-services/video/flags/vidsbase/on_production',
    'thumb': '/media-services/video/flags/production_vla_vidsth/on_production'
}

SHARDMAP_RESOURCE_TYPE = resource_types.VIDEO_BASE_SHARDMAP


class SwitchVideoDatabaseNG(SwitchMediaDatabase):
    """Переключение большой базы Видео"""

    type = 'SWITCH_VIDEO_DATABASE_NG'
    switch_type = 'video'

    # YDL
    YDL_TOKEN_NAME = 'ydl_video_token'

    # Monitoring settings
    monitoring_sleep = 10 * 60  # 10 min
    monitoring_time = 7 * 60 * 60  # 7 hours
    monitoring_telegram_chat_id = '-1001117977095'
    monitoring_email_to = 'video-newdb@yandex-team.ru'
    monitoring_vault_name = 'video-warden-bot-token'
    monitoring_vault_owner = 'VIDEO-ROBOT'

    def initCtx(self):
        SwitchMediaDatabase.initCtx(self)

        # override inputs
        self.ctx[SwitchDashboardName.name] = SWITCH_DASHBOARD_NAME
        self.ctx[SwitchDashboardRecipe.name] = DATABASE_SWTICH_RECIPE
        self.ctx[NewDBDashboardName.name] = NEWDB_DASHBOARD_NAME
        self.ctx[ZkFlags.name] = ZK_FLAGS

    def sanity_checks(self):
        """Sanity checks."""
        self.set_info("Start acceptance: {}".format(self.ctx[ShardmapName.name]))
        logging.debug("Run db acceptance")

        # get shardmap file with shards
        list_resources = apihelpers.list_task_resources(
            task_id=self.ctx[ShardmapTaskToDeploy.name],
            resource_type=SHARDMAP_RESOURCE_TYPE,
            attribute_name='shardmap_name',
            attribute_value=self.ctx[ShardmapName.name],
            limit=1,
            status='READY'
        )

        logging.debug("list_resources: %s", list_resources)
        for rs in list_resources:
            path = self.sync_resource(rs.id)
            logging.debug('path %s', path)
            break

        shardmap = Shardmap(shardmap_filename=self.ctx[ShardmapName.name],
                            shardmap_file_path=path)

        accepter = VideoAccept(self, shardmap=shardmap)
        accepter.accept()
        self.set_info("Done acceptance: {}".format(self.ctx[ShardmapName.name]))
        logging.debug("Done db acceptance")


__Task__ = SwitchVideoDatabaseNG
