import json
import logging

from sandbox import sdk2


ENVIRONMENT_PRODUCTION = 'production'
ENVIRONMENT_TESTING = 'testing'

PRODUCTION_RESOURCES_OWNER = 'TAXI_ML_MODELS_DEPLOY_PRODUCTION'
TESTING_RESOURCES_OWNER = 'TAXI_ML_MODELS_DEPLOY_TESTING'

RESOURCES_CHUNK_SIZE = 1000


def find_resources(resource_type, **attrs):
    offset = 0
    resources = []
    while True:
        chunk = list(resource_type.find(**attrs).order(-sdk2.Resource.id).limit(
            RESOURCES_CHUNK_SIZE).offset(offset))
        resources += chunk
        offset += RESOURCES_CHUNK_SIZE
        if len(chunk) < RESOURCES_CHUNK_SIZE:
            break

    logging.info('found %s resources with resource_type %s and filter %s',
                 len(resources), resource_type.__name__, json.dumps(attrs))
    return resources


def get_resources_owner(environment):
    if environment == ENVIRONMENT_TESTING:
        return TESTING_RESOURCES_OWNER
    elif environment == ENVIRONMENT_PRODUCTION:
        return PRODUCTION_RESOURCES_OWNER
    else:
        raise Exception('wrong environment value: ' + environment)
