# -*- coding: utf-8 -*-
import logging

from sandbox import sdk2
from sandbox.projects.stop_leak.base_hector_task.hector_git import BaseHectorGitTask
from sandbox.projects.stop_leak.resource_types import HectorResults
from sandbox.sdk2.helpers import subprocess as sp
import os
import base64
import codecs


class AntSecretGH(BaseHectorGitTask):
    vcs = 'github'
    hector_command = 'gh'
    use_ssh = True

    class Parameters(BaseHectorGitTask.Parameters):
        repository_name = sdk2.parameters.String('Repository name', default='a-konyshev/test')
        vcs_type = sdk2.parameters.String('VCS type: gh or bb', default='gh')

    def _hector_env(self):
        env = super(AntSecretGH, self)._hector_env()
        env['GHTOKEN'] = sdk2.Vault.data(self.owner, 'STOP_LEAK_GITHUB_TOKEN')
        return env

    def _hector_command(self):
        hector_cmd, ant_secret_cmd = super(AntSecretGH, self)._hector_command()
        if self.Parameters.excludes:
            ant_secret_cmd.append('--excludes=' + self.Parameters.excludes)
        if self.Parameters.not_ignore:
            ant_secret_cmd.append('--not-ignore')
        hector_cmd.append('--repos=' + self.Parameters.repository_name)

        if self.Parameters.vcs_type in ['gh', 'bb']:
            self.hector_command = self.Parameters.vcs_type

        return hector_cmd, ant_secret_cmd

    def _prepare_env(self):
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('install_crypto_lib')) as pl:
            sp.check_call(
                os.path.join(os.path.abspath(os.path.dirname(__file__)), 'install_crypto_lib.sh'),
                stdout=pl.stdout, stderr=pl.stderr)

        super(AntSecretGH, self)._prepare_env()

    def _save_to_res(self):
        results_archive_path = str(self.path('results.tar.gz'))

        if os.path.isdir(self.results_path) is False or os.listdir(self.results_path) == []:
            return

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('create results archive')) as pl:
            sp.check_call('cd {path} && tar cvzf {tgz} *'.format(path=self.results_path, tgz=results_archive_path),
                          shell=True, stderr=pl.stdout, stdout=pl.stdout)

        logging.info(results_archive_path)
        try:
            from aes_encryption import AESCipher
            d = open(results_archive_path, "rb").read()
            logging.info('Read %d bytes from %s' % (len(d), results_archive_path))
            b64_d = base64.b64encode(d)
            key = sdk2.Vault.data(self.owner, 'ANT_SECRET_RESULTS_KEY')
            aes = AESCipher(key)
            enc_d = aes.encrypt(b64_d)
            logging.info('Encrypted data length = %d' % len(enc_d))

            file = codecs.open(results_archive_path, 'wb', 'utf-8')
            file.write(enc_d)
            file.close()
            logging.info('Prepare to ResourceData')
            sdk2.ResourceData(
                HectorResults(
                    self,
                    'Hector %s results' % self.vcs,
                    results_archive_path,
                    results_type=self.vcs
                )
            )
            logging.info('Success')
        except Exception as e:
            logging.info('AAAAA: Error')
            logging.info(e)
