# coding=utf-8
import re
import os
from glob import glob
import json
from hashlib import sha1
import argparse


FILE_EXTENSION = [
    '.py',
    '.cpp',
    '.c',
    '.js',
    '.cs',
    ]

"""
C#
_logger
Logger
_blacklistLogger
logger
_pushLogger
_qcLogger
Writer
_eventsLogger


https://docs.microsoft.com/en-us/dotnet/api/microsoft.extensions.logging.loggerextensions.logwarning?view=aspnetcore-2.1
LogCritical
LogDebug
LogError
LogInformation
LogTrace
LogWarning
Log
BeginScope



TODO: raise ()
"""


REGEX = {
    '.py': re.compile('logger\\..*?\\([\\s\\S]*?\\)\\r?\\n'),
    '.cs': re.compile('logger\\..*?\\([\\s\\S]*?\\)[;\)]\\r?\\n')
}

EXCLUDE_PATH = ['/venv/']

OK_LANGUAGES = ['python', 'asp']


def get_files(dirname, ext='*'):
    return [y for x in os.walk(dirname) for y in glob(os.path.join(x[0], '*.' + ext))]


def read_file(fname):
    try:
        f = open(fname, 'r', encoding='utf-8')
        d = f.read()
        f.close()
        return d
    except UnicodeDecodeError as e:
        print(e)
        f = open(fname, 'r', encoding='latin1')
        d = f.read()
        f.close()
        return d


def get_file_extension(fname):
    filename, file_extension = os.path.splitext(fname)
    return file_extension


def get_line_number_by_lookup(filename, lookup):
    with open(filename) as myFile:
        for num, line in enumerate(myFile, 1):
            if lookup in line:
                return num


def find_bad_words(data):
    bad_words = [
        'token',
        'session',
        'password',
        'login',
        'tvm',
        'sid',
        'sid2',
        'xiva',
        'taxifee',
        'passport',
        'blackbox',
        'sessionId',
        'db_id',
        'user_id',
        'cookie',
        'accountName',
        'accountNumber',
        'active_domain',
        'admin',
        'admin_pwd',
        'administrator',
        'aeskey',
        'api',
        'api_key',
        'api_secret_key',
        'appsettings',
        'auth_login',
        'auth_pass',
        'auth_pwd',
        'auth_token',
        'auth_user',
        'blowfish_secret',
        'botnet_cryptkey',
        'ccn',
        'config',
        'config_file',
        'connectionstr',
        'connectionstring',
        'credential',
        'credentials',
        'db_host',
        'db_hostname',
        'db_login',
        'db_pass',
        'db_password',
        'db_pwd',
        'db_user',
        'db_username',
        'dbDatabase',
        'dbhost',
        'dbms',
        'dbname',
        'dbpass',
        'dbpasswd',
        'dbport',
        'dbserver',
        'dbtype',
        'dbuser',
        'defaultpassword',
        'defaultusername',
        'delete',
        'dob',
        'email',
        'enckey_',
        'encryption-key',
        'encryptionkey',
        'ftpconfig',
        'gpass',
        'gradle.properties',
        'guest',
        'hash',
        'hashed',
        'host',
        'hostname',
        'is_admin',
        'key',
        'key_for_gcm',
        'login',
        'loginpassw',
        'logon',
        'loki',
        'm_db',
        'm_host',
        'm_pwd',
        'm_user',
        'mail',
        'mysql_connect',
        'mysql_database',
        'mysql_host',
        'mysql_pass',
        'mysql_user',
        'nanopool_wallet',
        'need_password',
        'notify_upd_key',
        'npwd',
        'nusr',
        'opwd',
        'ousr',
        'pass',
        'pass_db',
        'passcode',
        'passphrase',
        'passwd',
        'password',
        'pop3',
        'private',
        'private_key',
        'proxypassword',
        'pw',
        'pwcache',
        'pwd',
        'pwd_for_server',
        'rc4key',
        'rootpw',
        'rot13',
        'salt',
        'secret',
        'secret-key',
        'secret_key',
        'secretkey',
        'select',
        'smtp',
        'ssn',
        'system_id',
        'table_prefix',
        'token',
        'token.org',
        'uid',
        'uname',
        'update',
        'url_gcm_api',
        'user',
        'user_db',
        'userid',
        'username',
        'userpassphrase',
        'userpassword',
        'vulnerable',
        'wallet_',
        'web.config',
        'wombat',
        'sDatabase',
        'sPanelUsername',
        'sPanelPassword',
        'sUser',
        'sHost'
    ]

    for word in bad_words:
        if word in data:
            return True


def make_sha1(s, encoding='utf-8'):
    result = sha1(s.encode(encoding)).hexdigest()
    return result


def find_log(f):
    result = []
    for i in EXCLUDE_PATH:
        if i in f:
            return result
    if not os.path.isfile(f):
        return result

    ext = get_file_extension(f)

    if ext not in FILE_EXTENSION or ext not in REGEX:
        return result

    data = read_file(f)
    r = REGEX[ext]
    for i in r.findall(data):
        if find_bad_words(i):
            result.append(
                {
                    'path': f,
                    'line_no': 0,
                    'problem': {
                        'plugin': 'logging_finder',
                        'message': i,
                        'additional': {
                            'sha1': make_sha1(i)
                        }
                    }
                }
            )
    return result


def main():
    parser = argparse.ArgumentParser("simple_example")
    parser.add_argument("--work", help="work path", type=str)
    parser.add_argument('fix_for_hector', help='fix_for_hector', type=str)
    args = parser.parse_args()

    path = args.work
    files = get_files(path)

    counter = 0
    result = []
    for f in files:
        result += find_log(f)
        if len(result) != 0:
            counter += len(result)

    print(json.dumps(result))


if __name__ == '__main__':
    main()
