# -*- coding: utf-8 -*-
import logging
from sandbox import sdk2
import os
from sandbox.projects.stop_leak.base_hector_task.hector_git import BaseHectorGitTask
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.common.types import client as ctc


class ESLintSecurity(BaseHectorGitTask):
    vcs = 'github'
    hector_command = 'gh'
    use_ssh = True

    class Requirements(BaseHectorGitTask.Requirements):
        client_tags = ctc.Tag.LINUX_XENIAL

    class Parameters(BaseHectorGitTask.Parameters):
        repository_name = sdk2.parameters.String('Repository name', default='a-konyshev/test')
        vcs_type = sdk2.parameters.String('VCS type: gh or bb', default='gh')

    def _hector_env(self):
        env = super(ESLintSecurity, self)._hector_env()
        env['GHTOKEN'] = sdk2.Vault.data(self.owner, 'STOP_LEAK_GITHUB_TOKEN')
        return env

    def _prepare_env(self):
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('install_eslintsecurity')) as pl:
            sp.check_call(
                os.path.join(os.path.abspath(os.path.dirname(__file__)), 'install__eslintsecurity.sh'),
                stdout=pl.stdout, stderr=pl.stderr)

        super(ESLintSecurity, self)._prepare_env()

    def _hector_command(self):
        hector_cmd, ant_secret_cmd = super(ESLintSecurity, self)._hector_command()
        hector_cmd.append('--repos=' + self.Parameters.repository_name)
        hector_cmd.remove('--parse-stdout')

        eslint_cmd = [
            '--',
            'bash',
            os.path.join(os.path.abspath(os.path.dirname(__file__)), 'run__eslintsecurity.sh'),
            str(self.work_path) + '/' + str(self.Parameters.repository_name),
            os.path.abspath(os.path.dirname(__file__))
        ]

        if self.Parameters.vcs_type in ['gh', 'bb']:
            self.hector_command = self.Parameters.vcs_type

        return hector_cmd, eslint_cmd

    def _run_hector(self, cmd):
        logging.info('_run_eslint_security cmd: ')
        logging.info(str(cmd))

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('eslint_security')) as pl:
            env = self._hector_env()
            sp.check_call(cmd, env=env, stdout=pl.stdout, stderr=pl.stderr)

        logging.info("_run_eslint_security")
