# -*- coding: utf-8 -*-
import logging

from sandbox import sdk2
from sandbox.projects.stop_leak.base_hector_task.hector_git import BaseHectorGitTask
from sandbox.sdk2.helpers import subprocess as sp
import os


class ScanerBanditPython3(BaseHectorGitTask):
    vcs = 'github'
    hector_command = 'gh'
    use_ssh = True

    class Parameters(BaseHectorGitTask.Parameters):
        repository_name = sdk2.parameters.String('Repository name', default='a-konyshev/test')
        vcs_type = sdk2.parameters.String('VCS type: gh or bb', default='gh')
        python_version = sdk2.parameters.String("Python version: 2 or 3", default="3", required=True)

    def _hector_env(self):
        env = super(ScanerBanditPython3, self)._hector_env()
        env['GHTOKEN'] = sdk2.Vault.data(self.owner, 'STOP_LEAK_GITHUB_TOKEN')
        return env

    def _prepare_env(self):
        if self.Parameters.python_version == '2':
            with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('install__bandit_python2')) as pl:
                sp.check_call(
                    os.path.join(os.path.abspath(os.path.dirname(__file__)), 'install__bandit_python2.sh'),
                    stdout=pl.stdout, stderr=pl.stderr)
        else:
            with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('install__bandit')) as pl:
                sp.check_call(
                    os.path.join(os.path.abspath(os.path.dirname(__file__)), 'install__bandit.sh'),
                    stdout=pl.stdout, stderr=pl.stderr)

        super(ScanerBanditPython3, self)._prepare_env()

    def _hector_command(self):
        hector_cmd, ant_secret_cmd = super(ScanerBanditPython3, self)._hector_command()
        if self.Parameters.excludes:
            ant_secret_cmd.append('--excludes=' + self.Parameters.excludes)
        if self.Parameters.not_ignore:
            ant_secret_cmd.append('--not-ignore')
        repository_name = self.Parameters.repository_name
        if 'github.yandex-team.ru/' in repository_name:
            repository_name = repository_name.split('github.yandex-team.ru/')[1]
        elif 'bb.yandex-team.ru/' in repository_name:
            repository_name = repository_name.split('bb.yandex-team.ru/')[1]

        hector_cmd.append('--repos=' + repository_name)
        hector_cmd.remove('--parse-stdout')

        if self.Parameters.vcs_type in ['gh', 'bb']:
            self.hector_command = self.Parameters.vcs_type

        yodax_cmd = [
            '--',
            'bandit',
            '-r',
            '-ll',
            '-f',
            'json',
            self.work_path
        ]

        # os.system('bandit -r -ll -f json ' + directory + ' > ' + temp.name)

        return hector_cmd, yodax_cmd

    def _run_hector(self, cmd):
        logging.info('_run_hector cmd: ')
        logging.info(str(cmd))

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('hector')) as pl:
            env = self._hector_env()
            sp.check_call(cmd, env=env, stdout=pl.stdout, stderr=pl.stderr)

        logging.info("_run_hector")
