# -*- coding: utf-8 -*-
import logging
from sandbox import sdk2
import os
from sandbox.projects.stop_leak.base_hector_task.hector_git import BaseHectorGitTask
from sandbox.sdk2.helpers import subprocess as sp


class YodaxAnalyzer(BaseHectorGitTask):
    vcs = 'github'
    hector_command = 'gh'
    use_ssh = True

    class Parameters(BaseHectorGitTask.Parameters):
        repository_name = sdk2.parameters.String('Repository name', default='a-konyshev/test')
        vcs_type = sdk2.parameters.String('VCS type: gh or bb', default='gh')
        includes = sdk2.parameters.String('Includes', default='.nginx')

    def _hector_env(self):
        env = super(YodaxAnalyzer, self)._hector_env()
        env['GHTOKEN'] = sdk2.Vault.data(self.owner, 'STOP_LEAK_GITHUB_TOKEN')
        return env

    def _prepare_env(self):
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('install__yodax')) as pl:
            sp.check_call(
                os.path.join(os.path.abspath(os.path.dirname(__file__)), 'install__yodax.sh'),
                stdout=pl.stdout, stderr=pl.stderr)

        super(YodaxAnalyzer, self)._prepare_env()

    def _hector_command(self):
        hector_cmd, ant_secret_cmd = super(YodaxAnalyzer, self)._hector_command()
        hector_cmd.append('--repos=' + self.Parameters.repository_name)

        yodax_cmd = [
            '--',
            'python',
            os.path.join(os.path.abspath(os.path.dirname(__file__)), 'worker.py'),
            '--work=' + self.work_path,
            '--repos=' + self.Parameters.repository_name
        ]

        if self.Parameters.vcs_type in ['gh', 'bb']:
            self.hector_command = self.Parameters.vcs_type

        return hector_cmd, yodax_cmd

    def _run_hector(self, cmd):
        logging.info('_run_hector cmd: ')
        logging.info(str(cmd))

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('hector')) as pl:
            env = self._hector_env()
            sp.check_call(cmd, env=env, stdout=pl.stdout, stderr=pl.stderr)

        logging.info("_run_hector")
