# -*- coding: utf-8 -*-
import json
import argparse
import os
import re
import subprocess


def find_files_by_ext(path, ext):
    """
    Find all files in directories, which have substring ext

    path - absolute path
    ext - '.nginx'
    """
    result = []
    ext = ext.replace('.', '')
    for root, dirs, files in os.walk(path):
        for file in files:
            if re.search('\.' + ext + '.*', file):
                result.append(os.path.join(root, file))
    return result


def find_files_by_dirname(path, dirname, exts=[]):
    """
    Find all files in directories, which include in their path dirname value

    path - absolute path
    dirname - /etc/nginx/smth
    exts - ['.nginx', '.conf']
    """
    result = []
    for root, dirs, files in os.walk(path):
        if '/%s' % dirname in root:
            for file in files:
                if file.endswith(tuple(exts)):
                    result.append(os.path.join(root, file))
    return result


def get_yodax_result(fname):
    try:
        p = subprocess.Popen(['yodax', fname, '-f', 'json'], stdout=subprocess.PIPE)
        result = p.communicate()[0]
        return result
    except Exception as e:
        print(e)
        return ''


def main():
    parser = argparse.ArgumentParser("simple_example")
    parser.add_argument("--work", help="work path", type=str)
    parser.add_argument('--repos', help='repository name', type=str)
    parser.add_argument('fix_for_hector', help='fix_for_hector', type=str)
    args = parser.parse_args()

    ext = '.nginx'
    dirname = 'nginx'
    path = os.path.join(args.work, args.repos)
    files = []
    files += find_files_by_ext(path, ext)
    files += find_files_by_dirname(path, dirname, ['.nginx', '.conf'])

    result = []
    for i in files:
        yodax_result = get_yodax_result(i)
        if yodax_result != '[]\n' and yodax_result is not None:
            for j in json.loads(yodax_result):
                result.append(
                    {
                        'path': i,
                        'line_no': 1,
                        'problem': j
                    }
                )

    print(json.dumps(result))


if __name__ == '__main__':
    main()
