import logging
import time
import requests
import sandbox.common.types.task as ctt
from sandbox import sdk2
from sandbox.projects.TeamcityAgentlessTask.AgentlessBase import AgentlessBase


class TeamcityAgentlessProxy(sdk2.Task, AgentlessBase):

    class Parameters(sdk2.Task.Parameters):
        branch = sdk2.parameters.String("Branch name")
        commit = sdk2.parameters.String("Commit id")
        task_name = sdk2.parameters.String("Task name")
        agentless_forward_logs = sdk2.parameters.Bool("Send logs in the end", default=False)
        agentless_upload_service_messages = sdk2.parameters.Bool("Upload service messages", default=False)
        # with sdk2.parameters.Output():
        #     results = sdk2.parameters.Integer("Returned results")

    def get_child_resources(self):
        childs = list(sdk2.Task.find(id=self.Context.child).limit(0))
        resources = []
        service_messages_resources = []
        while len(childs) > 0:
            cur_task = childs.pop(0)
            resources += [
                r for r in sdk2.Resource.find(task=cur_task).limit(0) if r.type == 'TEAMCITY_ARTIFACTS'
            ]
            service_messages_resources += [
                r for r in sdk2.Resource.find(task=cur_task).limit(0) if r.type == 'TEAMCITY_SERVICE_MESSAGES_LOG'
            ]
            # childs += list(sdk2.Task.find(parent=cur_task).limit(0))
        return resources, service_messages_resources

    @AgentlessBase.Decorators.agentless_create_safe(logging.getLogger("agentless"))
    def on_execute(self):
        logger = logging.getLogger("agentless")
        with self.memoize_stage.first_step:
            self._add_build_comment("Created sandbox task sandbox-{}".format(self.id))
            new_context = [(k, v) for k, v in self.Context.sandbox_task_launcher_context.items()
                           if not k.startswith("__") and not k.startswith("_")
                           and not k.startswith("agentless") and not k.startswith("parameter.")]
            parameters = [(k, v) for k, v in dict(self.Parameters).items() if not k.startswith("__")]
            parameters += [(k[10:], v) for k, v in self.Context.sandbox_task_launcher_context.items()
                           if k.startswith("parameter.")]
            parameters += [("sandbox_task_launcher_context", new_context)]
            logger.info("Starting child task")
            child = sdk2.Task[self.Parameters.task_name](
                self,
                description="Child of {}".format(self.id),
                owner=self.owner,
                **{k: v for k, v in parameters if k != "owner" and k != "description"}
            ).enqueue()
            self.Context.child = child.id
            self.Context.save()
            logger.info("Starting wait")
            raise sdk2.WaitTask(child, (ctt.Status.Group.FINISH, ctt.Status.Group.BREAK), wait_all=True)
        child = list(sdk2.Task.find(id=self.Context.child).limit(0))[0]
        if child.status != "SUCCESS":
            logger.error("Child task failed")
            self._notify_on_failure()
            return
        logger.info("Child task done! Starting resource uploading")
        time.sleep(5)
        resources, service_messages_resources = self.get_child_resources()
        for res in resources:
            logger.info(res.id)
            self._set_upload_resource(sdk2.Resource[res.id])
        if self.Parameters.agentless_forward_logs is True:
            for res in resources:
                if res.type == "TEAMCITY_ARTIFACTS":
                    data = sdk2.ResourceData(res)
                    path = str(data.path)
                    logger.info(path + "/full_log.txt")
                    f = open(path + "/full_log.txt", "r")
                    logger.info("Uploading logs")
                    for line in f.readlines():
                        logger.info(line)
        for res in service_messages_resources:
            self.logger.info('Starting sending predefined service messages')
            data = sdk2.ResourceData(res)
            path = str(data.path)
            f = open(path, 'r')
            if self.Parameters.agentless_upload_service_messages is True:
                filename = path.split('/')[-1]
                _ = requests.post(
                    '{0}/artifactUpload.html'.format(self.ctx["agentless_server_url"]),
                    headers=self.auth,
                    files={filename: f},
                    data={'buildId': self.ctx["agentless_build_id"], 'path': str('.teamcity')}
                )
            for line in f.readlines():
                self._send_log_request(line)
        logger.info("Finishing")
