# -*- coding: utf-8 -*-

from sandbox.projects.TeamcityRunner import TeamcityRunner
from sandbox.sandboxsdk import environments


class TeamcityRunnerWithPip(TeamcityRunner):

    type = 'TEAMCITY_RUNNER_PIP'

    def ExecuteAndProcessLogs(self, command, prefix, env=None):
        with environments.VirtualEnvironment(use_system=True) as venv:
            venv.pip('devtools.fleur')
            TeamcityRunner.ExecuteAndProcessLogs(self, command, prefix)

    def Test(self):
        with environments.VirtualEnvironment(use_system=True) as venv:
            venv.pip('devtools.fleur')
            return TeamcityRunner.Test(self)


__Task__ = TeamcityRunnerWithPip
