# -*- coding: utf-8 -*-

import os

from sandbox.projects import resource_types
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.paths import copy_path
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import LastReleasedResource, SandboxArcadiaUrlParameter


REVISION_CTX_KEY = 'revision'


class ArcadiaUrl(SandboxArcadiaUrlParameter):
    name = 'arcadia_url'
    description = 'Svn url for arcadia'
    default_value = Arcadia.trunk_url()


class QuerySearchBaseResource(LastReleasedResource):
    name = 'querysearch_base_resource_id'
    description = 'Querysearch release'
    resource_type = resource_types.QUERYSEARCH_BASE_EXECUTABLE


class ThumbsBanBuildQuerysearch(SandboxTask):
    """
        Build querysearch and its config for thumbnails ban.
        Actually will not build querysearch executable, but copy it from an existing task/release
    """

    type = 'THUMBS_BAN_BUILD_QUERYSEARCH'

    input_parameters = (ArcadiaUrl, QuerySearchBaseResource)

    def get_config_path(self):
        return self.abs_path(os.path.basename(resource_types.THUMBS_BAN_QUERYSEARCH_CONFIG.arcadia_path))

    def get_executable_path(self):
        return self.abs_path('querysearch')

    def on_enqueue(self):
        self.create_resource(self.descr, self.get_config_path(), resource_types.THUMBS_BAN_QUERYSEARCH_CONFIG)
        self.create_resource(self.descr, self.get_executable_path(), resource_types.THUMBS_BAN_QUERYSEARCH_EXECUTABLE)

    def on_execute(self):
        # Append revision to make results same after copy-pasting task
        revision = Arcadia.get_revision(self.ctx[ArcadiaUrl.name])
        self.ctx[REVISION_CTX_KEY] = revision
        arcadia_url = Arcadia.replace(self.ctx[ArcadiaUrl.name], revision=revision)
        self.ctx[ArcadiaUrl.name] = arcadia_url

        arcadia_path = Arcadia.append(arcadia_url, resource_types.THUMBS_BAN_QUERYSEARCH_CONFIG.arcadia_path)
        Arcadia.export(arcadia_path, self.get_config_path())

        source_executable = self.sync_resource(self.ctx[QuerySearchBaseResource.name])
        copy_path(source_executable, self.get_executable_path())

    def arcadia_info(self):
        fake_tag = "thumbs-ban-r{}".format(self.ctx[REVISION_CTX_KEY]) if REVISION_CTX_KEY in self.ctx else None
        return 0, fake_tag, None


__Task__ = ThumbsBanBuildQuerysearch
