# -*- coding: utf-8 -*-
from __future__ import division
from __future__ import unicode_literals
from __future__ import absolute_import

import logging
import requests

import sandbox.common.types.task as ctt

from sandbox import sdk2

from sandbox.projects.TickenatorBatchProcessing.YasmScreenshoter import YasmScreenshoter


class TakeYasmScreenshots(sdk2.Task):
    class Context(sdk2.Context):
        list_of_urls = []
        yasm_url = ''
        create_subtasks = False
        subtasks = []
        number_of_subtasks = 0
        __STAGES = {}

    class Parameters(sdk2.Task.Parameters):
        # common parameters
        kill_timeout = 3600

        # Список урлов которые нужно поскриншотить
        list_of_urls = sdk2.parameters.List(
            'Yasm urls',
            description='Yasm urls, which be a screenshoted'
        )
        # get_png = sdk2.parameters.Bool('Get PNG instead url', default=False, required=False)
        # Если true, нужно добавить 2 дополнительных параметра
        for_tickenator = sdk2.parameters.Bool('Will be runned for tickenator')
        with for_tickenator.value[True]:
            # Урл в который будет возвращен результат
            callback_url = sdk2.parameters.Url('Callback url',
                                               required=True,
                                               default='tickenator.n.yandex-team.ru')
            # Уникальный номер операции
            uuid = sdk2.parameters.String('UUID',
                                          required=True)
        with sdk2.parameters.Output:
            screenshoted_urls = sdk2.parameters.Dict('Screenshots:')

    def on_prepare(self):
        for i in self.Parameters.__custom_parameters_names__:
            try:
                attr = getattr(self.Parameters, i)
                setattr(self.Context, i, attr)
                logging.debug('Successful added \'{}\' to context, with attr \'{}\''.format(i, attr))
            except Exception as e:
                logging.debug('Cannot get attr {}'.format(i))
                logging.debug(e)

        logging.info('Parameters: {}'.format(self.Parameters))
        logging.info('Context: {}'.format([x for x in self.Context.__values__]))
        logging.debug('Len of list_of_urls: {}'.format(len(self.Parameters.list_of_urls)))
        if len(self.Parameters.list_of_urls) >= 1:
            self.Context.create_subtasks = True
            # setattr(self.Parameters, 'create_subtask', True)
            self.Context.number_of_subtasks = len(self.Parameters.list_of_urls)
            # setattr(self.Parameters, 'number_of_subtasks', len(self.Parameters.list_of_urls))
        else:
            logging.warning('No list_of_urls was given to task!')
            ctt.Status.FAILURE('No list_of_urls was given to task!')

    def _create_childrens(self):
        logging.info('Creating childrens...')
        subtasks = {}
        self.Context.result_dict_urls = {}
        self.Context.subtasks = []
        logging.debug('subtasks amount: {}'.format(self.Context.number_of_subtasks))
        if self.Context.number_of_subtasks:
            for i in range(self.Context.number_of_subtasks):
                logging.debug('Creating subtask #{}'.format(i))
                subtask = YasmScreenshoter(
                    parent=self,
                    description="Child of test task {}".format(self.id),
                    yasm_url=self.Context.list_of_urls[i - 1],
                    exec_limit=300,
                    priority=ctt.Priority(ctt.Priority.Class.USER, ctt.Priority.Subclass.HIGH)
                )
                self.Context.result_dict_urls[self.Context.list_of_urls[i - 1]] = subtask.id
                logging.debug('Preresulted urls dict: {}'.format(self.Context.result_dict_urls))
                subtask.save()
                subtasks[subtask.enqueue()] = 'result_url'
                self.Context.subtasks = map(lambda _: _.id, subtasks)
                logging.debug('subtask: {}'.format(subtask))
                logging.debug('self.Context.subtasks = {}'.format(self.Context.subtasks))
            logging.debug('Subtasks dict: {}'.format(subtasks))
            logging.info('Children creating ended')
            return subtasks
        else:
            # No urls to yasm was given to task
            return None

    def on_execute(self):
        with self.memoize_stage.create_children:
            subtasks = self._create_childrens()
            if subtasks:
                raise sdk2.WaitOutput(subtasks, True)
            else:
                logging.warning('No list_of_urls was given to task!')

    def on_finish(self, prev_status, status):
        logging.info('Prev status {}, next status {}'.format(prev_status, status))
        param = {'uuid': self.Parameters.uuid}
        logging.debug('Finishing... Context sutasks: {}'.format(self.Context.subtasks))
        subtasks = list(self.find(id=self.Context.subtasks).limit(len(self.Context.subtasks)))
        logging.debug('subtasks: {}'.format(subtasks))

        for task in subtasks:
            logging.debug('task: {}'.format(task))
            if self.Context.result_dict_urls.get(task.Parameters.yasm_url):
                self.Context.result_dict_urls[task.Parameters.yasm_url] = task.Parameters.result_url
        param.update(self.Context.result_dict_urls)
        logging.debug('Sending to callback url data: {}'.format(param))
        self.Parameters.screenshoted_urls = self.Context.result_dict_urls
        response = requests.put(
            self.Parameters.callback_url,
            data=param
        )
        logging.info('Response from callback: {}'.format(response))
        logging.info('Status code: {}'.format(response.status_code))
        logging.info('Text body: {}'.format(response.text))
