#!/usr/bin/env python2
# pylint: disable=invalid-name,missing-docstring,line-too-long

import os
import copy
import logging
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters
import sandbox.projects.resource_types

import caas_configure


class ToolsCaasConfigureTask(sdk_task.SandboxTask):
    type = "TOOLS_CAAS_CONFIGURE"
    input_parameters = []
    execution_space = 20

    static_parameters = {}

    def on_execute(self):
        self.ctx.update(self.static_parameters)
        logging.info("Generating CaaS configs")
        caas_configure.process(copy.deepcopy(self.ctx))

        logging.info("Creating backend config resource")
        self.create_resource(
            self.descr + ' backend config',
            os.path.join(self.ctx['dest'], 'cached'),
            sandbox.projects.resource_types.TOOLS_CAAS_BACKEND_CONFIG,
        )

        logging.info("Creating proxy config resource")
        self.create_resource(
            self.descr + ' proxy config',
            os.path.join(self.ctx['dest'], 'caas-proxy'),
            sandbox.projects.resource_types.TOOLS_CAAS_PROXY_CONFIG,
        )


def add_task_arguments():
    for group in caas_configure.get_argument_info():
        for v in group['args']:
            if not v.sandbox_value:
                arg_name = "Arg" + v.name

                if v.type == int:
                    base_class = sdk_parameters.SandboxIntegerParameter
                elif v.type == bool:
                    base_class = sdk_parameters.SandboxBoolParameter
                else:
                    base_class = sdk_parameters.SandboxStringParameter

                setattr(
                    ToolsCaasConfigureTask,
                    arg_name,
                    type(
                        arg_name,
                        (base_class,), {
                            'group': group['name'],
                            'name': v.name,
                            'description': "%s [%s]" % (v.desc, str(v.default)),
                            'default_value': v.default,
                            'required': v.required
                        }
                    )
                )

                ToolsCaasConfigureTask.input_parameters.append(getattr(ToolsCaasConfigureTask, arg_name))
            else:
                ToolsCaasConfigureTask.static_parameters[v.name] = v.sandbox_value


add_task_arguments()


__Task__ = ToolsCaasConfigureTask
