# pylint: disable=invalid-name,missing-docstring,line-too-long

import re
import gencfg
import logging

mock_result = {}
_gen_instances_used_ids = {}


def _gen_slave_groups():
    return {
        'debug': {},
        'slaves': [
            'MERCURY_BASE', 'VENUS_BASE', 'EARTH_BASE', 'MARS_BASE', 'JUPITER_BASE', 'SATURN_BASE', 'URANUS_BASE', 'NEPTUNE_BASE'
            'MERCURY_ORBIT', 'VENUS_ORBIT', 'EARTH_ORBIT', 'MARS_ORBIT', 'JUPITER_ORBIT', 'SATURN_ORBIT', 'URANUS_ORBIT', 'NEPTUNE_ORBIT'
        ],
    }


def _gen_instances(dc=None, port=12345, amount=1, memory=512*1024*1024):
    """
        Generate GenCfg reply based on given parameters
    """
    global _gen_instances_used_ids
    result = []
    location = 'moon'
    for i in range(0, amount):
        node_i = _gen_instances_used_ids.get(dc, 1)
        _gen_instances_used_ids[dc] = node_i + 1
        result.append({
            'dc': dc,
            'location': location,
            'port': port,
            'hostname': "%s-%d-mock" % (dc, node_i),
            'porto_limits': {'memory_guarantee': memory},
        })
    return {
        'debug': {},
        'instances': result,
    }


def query(url):
    """
        Return mock GenCfg query result
    """
    logging.info("Mock HTTP query, URL: %s" % url)
    if url not in mock_result:
        url_re = re.compile(r"http://api.gencfg.yandex-team.ru/(\S+)/searcherlookup/groups/(\S+)/instances")
        url_match = url_re.match(url)
        if url_match:
            branch, group = url_match.groups()

            parts = group.split('_')

            # Remove unndeeded prefix
            if parts[0] == 'MSK':
                parts.pop(0)

            assert len(parts) > 1, "Bad group name: %s" % group

            # Get datacenter from name
            dc = parts.pop(0).lower()

            mock_result[url] = _gen_instances(dc=dc, port=22122, amount=8, memory=2 * 1024 * 1024 * 1024)

        url_re = re.compile(r"http://api.gencfg.yandex-team.ru/(\S+)/groups/(\S+)/slaves")
        url_match = url_re.match(url)
        if url_match:
            mock_result[url] = _gen_slave_groups()

    assert url in mock_result, "URL is not mocked: %s" % url

    return mock_result[url]


def set_results(result):
    """
        Set custom GenCfg mock results
    """
    global mock_result
    global _gen_instances_used_ids
    mock_result = result
    _gen_instances_used_ids = {}


def install():
    gencfg.query = query
