# pylint: disable=invalid-name,missing-docstring,line-too-long

import json
import string


def encode(o, end_symbol=";\n"):
    if isinstance(o, dict):
        output = ""

        for key, value in o.iteritems():
            output += "%s = %s;\n" % (key, encode(value, ''))

        return "{\n" + add_indent(output, 4) + "}" + end_symbol
    else:
        return json.dumps(o)


def add_indent(s, numSpaces):
    res = string.split(s, '\n')
    res = [(numSpaces * ' ') + line for line in res if line]
    res = string.join(res, '\n')

    if s.endswith("\n"):
        res += "\n"

    return res
