# pylint: disable=invalid-name,missing-docstring,line-too-long

import json
import utils


def _nodes_config(nodes):
    return [{'host': node.hostname, 'address': utils.resolve(node.hostname), 'port': node.port, 'dc': node.dc} for node in nodes]


def generate(
        proxy_nodes=[],
        cache_nodes=[],

        quorum_reads_count=1,
        replication_factor=1,
        replication_read_factor=None,
        replication_write_factor=None,
        sync_writes_count=1,
        remote_replication_factor=0,
        remote_replication_read_factor=None,
        remote_replication_write_factor=None,
        remote_sync_writes_count=0,
        max_next_nodes_count=0,
        remote_max_next_nodes_count=0,

        threads=8,
        max_connections=None,
        max_outbound_connections=None,
        answer_time_buckets="",
        write_token="",

        cache_stats_probes_enabled=True,
        cache_stats_probes_min_depth=30,
        cache_stats_probes_max_depth=630,
        cache_stats_probes_amount=40,

        extra_config={}
):
    if not extra_config:
        extra_config = {}

    if replication_read_factor is None:
        replication_read_factor = replication_factor

    if replication_write_factor is None:
        replication_write_factor = replication_factor

    if remote_replication_read_factor is None:
        remote_replication_read_factor = remote_replication_factor

    if remote_replication_write_factor is None:
        remote_replication_write_factor = remote_replication_factor

    assert replication_read_factor is not None, "replication_read_factor was not specified"
    assert replication_write_factor is not None, "replication_write_factor was not specified"
    assert remote_replication_read_factor is not None, "remote_replication_read_factor was not specified"
    assert remote_replication_write_factor is not None, "remote_replication_write_factor was not specified"

    config = utils.mergedicts(
        {
            'quorum-reads-count': quorum_reads_count,
            'replication-read-factor': replication_read_factor,
            'replication-write-factor': replication_write_factor,
            'sync-writes-count': sync_writes_count,
            'remote-replication-read-factor': remote_replication_read_factor,
            'remote-replication-write-factor': remote_replication_write_factor,
            'remote-sync-writes-count': remote_sync_writes_count,
            'max-next-nodes-count': max_next_nodes_count,
            'remote-max-next-nodes-count': max_next_nodes_count,
            'threads': threads,
            'max-connections': max_connections,
            'max-outbound-connections': max_outbound_connections,
            'answer-time-buckets': answer_time_buckets,
            'proxy-nodes': _nodes_config(proxy_nodes),
            'cache-nodes': _nodes_config(cache_nodes),
            'write-token': write_token,
            'cache-stats': {
                'probes-enabled': cache_stats_probes_enabled,
                'probes-min-depth': cache_stats_probes_min_depth,
                'probes-max-depth': cache_stats_probes_max_depth,
                'probes-amount': cache_stats_probes_amount,
            }
        },
        extra_config
    )

    return json.dumps(config, indent=4, sort_keys=True)
