# pylint: disable=invalid-name,missing-docstring,line-too-long

import yaml
import yaml.representer
import socket


def mergedicts(*args):
    result = {}

    for arg in args:
        result = _mergedicts(result, arg)

    return result


def _mergedicts(dict1, dict2):
    result = {}
    for k in set(dict1.keys()).union(dict2.keys()):
        if k in dict1 and k in dict2:
            if isinstance(dict1[k], dict) and isinstance(dict2[k], dict):
                result[k] = mergedicts(dict1[k], dict2[k])
            else:
                result[k] = dict2[k]
        elif k in dict1:
            result[k] = dict1[k]
        else:
            result[k] = dict2[k]
    return result


def bytes2human(n, format="%(value)i%(symbol)s"):
    """
    >>> bytes2human(10000)
    '9K'
    >>> bytes2human(100001221)
    '95M'
    """
    symbols = ('B', 'K', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y')
    prefix = {}
    for i, s in enumerate(symbols[1:]):
        prefix[s] = 1 << (i+1)*10
    for symbol in reversed(symbols[1:]):
        if n >= prefix[symbol]:
            value = float(n) / prefix[symbol]
            return format % locals()
    return format % dict(symbol=symbols[0], value=n)


def human2bytes(s):
    """
    >>> human2bytes('1M')
    1048576
    >>> human2bytes('1G')
    1073741824
    """
    if type(s) is int:
        return s

    if s.isdigit():
        return int(s)

    symbols = ('B', 'K', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y')
    letter = s[-1:].strip().upper()
    num = s[:-1]
    assert num.isdigit() and letter in symbols
    num = float(num)
    prefix = {symbols[0]: 1}
    for i, s in enumerate(symbols[1:]):
        prefix[s] = 1 << (i+1)*10
    return int(num * prefix[letter])


def resolve(hostname):
    recs = []
    try:
        recs = socket.getaddrinfo(hostname, None, socket.AF_INET6, 0, socket.AI_CANONNAME)
    except:
        try:
            recs = socket.getaddrinfo(hostname, None, socket.AF_INET, 0, socket.AI_CANONNAME)
        except:
            pass

    assert len(recs), "Unable to resolve hostname '%s'" % (hostname)
    return recs[0][4][0]


class YAMLDumper(yaml.Dumper):
    def increase_indent(self, flow=False, indentless=False):
        return super(YAMLDumper, self).increase_indent(flow, False)
    pass


YAMLDumper.add_representer(str, yaml.representer.SafeRepresenter.represent_str)
YAMLDumper.add_representer(unicode, yaml.representer.SafeRepresenter.represent_unicode)
