#!/usr/bin/python
# -*- coding: utf-8 -*-

import os, sys, unittest

sys.path.insert(0, os.path.join(os.path.dirname(__file__), "../.."))

import caas.luadump


class TestLuaDump(unittest.TestCase):
    def test_empty(self):
        self.assertEqual(caas.luadump.encode({}), "{\n};\n")

    def test_dict(self):
        self.assertEqual(
            caas.luadump.encode({'int': 1, 'string': 'text value'}),
"""{
    int = 1;
    string = "text value";
};
"""
        )

    def test_nested(self):
        self.assertEqual(
                caas.luadump.encode({'int': 1, 'nested_dict': {'inside': 'outside'}}),
"""{
    int = 1;
    nested_dict = {
        inside = "outside";
    };
};
"""
        )


if __name__ == '__main__':
    unittest.main()
