#!/usr/bin/env python2
# pylint: disable=invalid-name,missing-docstring,line-too-long

import os
import copy
import logging
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters
import sandbox.projects.resource_types

import caas_genconfig


class ToolsCaasGenConfigTask(sdk_task.SandboxTask):
    type = "TOOLS_CAAS_GENCONFIG"
    input_parameters = []
    execution_space = 4

    static_parameters = {}

    def on_execute(self):
        self.ctx.update(self.static_parameters)
        logging.info("Generating CaaS configs")
        caas_genconfig.process(copy.deepcopy(self.ctx))

        logging.info("Creating backend config resource")
        self.create_resource(
            self.descr + ' backend config',
            os.path.join(self.ctx['dest'], 'backend'),
            sandbox.projects.resource_types.TOOLS_CAAS_BACKEND_CONFIG,
        )

        logging.info("Creating proxy config resource")
        self.create_resource(
            self.descr + ' proxy config',
            os.path.join(self.ctx['dest'], 'proxy'),
            sandbox.projects.resource_types.TOOLS_CAAS_PROXY_CONFIG,
        )


def add_task_arguments():
    for group in caas_genconfig.get_argument_info():
        for v in group['args']:
            if not v.sandbox_value:
                arg_name = "Arg" + v.name

                if v.type == int:
                    base_class = sdk_parameters.SandboxIntegerParameter
                elif v.type == bool:
                    base_class = sdk_parameters.SandboxBoolParameter
                else:
                    base_class = sdk_parameters.SandboxStringParameter

                setattr(
                    ToolsCaasGenConfigTask,
                    arg_name,
                    type(
                        arg_name,
                        (base_class,), {
                            'group': group['name'],
                            'name': v.name,
                            'description': v.desc,
                            'default_value': v.default,
                            'required': v.required
                        }
                    )
                )

                ToolsCaasGenConfigTask.input_parameters.append(getattr(ToolsCaasGenConfigTask, arg_name))
            else:
                ToolsCaasGenConfigTask.static_parameters[v.name] = v.sandbox_value


add_task_arguments()


__Task__ = ToolsCaasGenConfigTask
