# pylint: disable=invalid-name,missing-docstring,line-too-long

import requests
import logging
import time
import json


GENCFG_GROUPS_URL = 'http://api.gencfg.yandex-team.ru/{branch}/groups'
GENCFG_GROUP_SLAVES_URL = 'http://api.gencfg.yandex-team.ru/{branch}/groups/{group}/slaves'
GENCFG_INSTANCES_URL = 'http://api.gencfg.yandex-team.ru/{branch}/searcherlookup/groups/{group}/instances'

RETRY_DELAY = 1
RETRY_AMOUNT = 2


def gencfg_instances(branch, group):
    reply = query(GENCFG_INSTANCES_URL.format(branch=branch, group=group))

    if not reply:
        raise NameError("No group '%s' in branch '%s' of gencfg" % (branch, group))

    if 'instances' not in reply:
        raise NameError("No instances in group %s (branch %s)" % (group, branch))

    for v in reply['instances']:
        v['hostname'] = v['hostname'].replace('.yandex.ru', '.search.yandex.net')

    return reply['instances']


def groups_instances(branch, groups_list):
    result = {}
    for group in groups_list:
        result[group] = gencfg_instances(branch, group)
    return result


def query(url):
    for i in xrange(RETRY_AMOUNT):
        try:
            r = requests.get(url)
            return json.loads(r.content)
        except Exception as e:
            if i + 1 < RETRY_AMOUNT:
                logging.warning("Failed to fetch url '%s', retry %d/%d" % (url, i, RETRY_AMOUNT))
                time.sleep(RETRY_DELAY)
                continue
            else:
                raise NameError("Failed to fetch url '%s': %s" % (url, e))
