# pylint: disable=invalid-name,missing-docstring,line-too-long

import re
import gencfg
import logging

mock_result = {}
_gen_instances_used_ids = {}


def _gen_instances(dc=None, port=12345, amount=1, memory=512*1024*1024):
    """
        Generate GenCfg reply based on given parameters
    """
    result = []
    location = 'moon'
    for i in range(0, amount):
        if dc not in _gen_instances_used_ids:
            _gen_instances_used_ids[dc] = 0
        id = _gen_instances_used_ids[dc] + 1
        _gen_instances_used_ids[dc] = id
        result.append({
            'dc': dc,
            'location': location,
            'port': port,
            'hostname': "%s-%d-mock" % (dc, id),
            'porto_limits': {'memory_guarantee': memory},
        })
    return {
        'debug': {},
        'instances': result,
    }


def query(url):
    """
        Return mock GenCfg query result
    """
    logging.info("Mock HTTP query, URL: %s" % url)
    if url not in mock_result:
        url_re = re.compile(r"http://api.gencfg.yandex-team.ru/(\S+)/searcherlookup/groups/(\S+)/instances")
        url_match = url_re.match(url)
        if url_match:
            branch, group = url_match.groups()

            parts = group.split('_')

            # Remove unndeeded prefix
            if parts[0] == 'MSK':
                parts.pop(0)

            if len(parts) <= 1:
                raise NameError("Bad group name: %s" % group)

            # Get datacenter from name
            dc = parts.pop(0).lower()

            conf = {
                'AMOUNT': 8,
                'MEMORY': 2 * 1024 * 1024 * 1024,  # 2Gb
                'PORT': 10777,
            }
            arg = None
            for n in parts:
                if arg and n.isdigit():
                    conf[arg] = int(n)
                    arg = None
                else:
                    if n in conf:
                        arg = n

            mock_result[url] = _gen_instances(dc=dc, port=conf['PORT'], amount=conf['AMOUNT'], memory=conf['MEMORY'])
        else:
            raise NameError("URL is not mocked: %s" % url)

    return mock_result[url]


def set_results(result):
    """
        Set custom GenCfg mock results
    """
    global mock_result
    global _gen_instances_used_ids
    mock_result = result
    _gen_instances_used_ids = {}


def install():
    gencfg.query = query
