# pylint: disable=invalid-name,missing-docstring,line-too-long

import yaml
import logging
import os

import utils


def generate(proxy_nodes=None, group_nodes=None, prev_group_nodes=None, dc_rw_groups=None, dest_dir=None, extra_config=None):
    merged_group_hosts = {}
    for group_id, nodes in group_nodes.iteritems():
        if group_id not in merged_group_hosts:
            merged_group_hosts[group_id] = []

        for node in nodes:
            merged_group_hosts[group_id].append({
                'hostname': node['instance']['hostname'],
                'port': node['instance']['port'],
            })

    if prev_group_nodes:
        for group_id, nodes in prev_group_nodes.iteritems():
            if group_id not in merged_group_hosts:
                merged_group_hosts[group_id] = []

            for node in nodes:
                merged_group_hosts[group_id].append({
                    'hostname': node['instance']['hostname'],
                    'port': node['instance']['port'],
                })

    # Proxy nodes list
    proxy_hosts = []
    for proxy_node in proxy_nodes:
        proxy_hosts.append({
            'hostname': proxy_node['instance']['hostname'],
            'port': proxy_node['instance']['port'],
            'dc': proxy_node['instance']['dc']
        })

    if not extra_config:
        extra_config = {}

    config = utils.mergedicts(
        {
            'ellpitics_group_hosts': merged_group_hosts,
            'proxy_hosts': proxy_hosts,
            'dc_rw_groups': dc_rw_groups,
            'settings': {
                'local_write_sync_count': 1,
                'remote_write_sync_count': 1,
            },
        },
        extra_config
    )

    if dest_dir:
        config_dir = os.path.join(dest_dir, 'proxy')
        if not os.path.exists(config_dir):
            os.makedirs(config_dir)

        filename = os.path.join(config_dir, "proxy.conf")

        logging.info("writing config: %s" % filename)

        with open(filename, 'w') as outfile:
            yaml.dump(config, outfile, indent=4, Dumper=utils.YAMLDumper)
    else:
        logging.info("Proxy config:")
        print(yaml.dump(config, indent=4, Dumper=utils.YAMLDumper))
