# pylint: disable=invalid-name,missing-docstring,line-too-long

import yaml
import yaml.representer


def mergedictsX(dict1, dict2):
    for k in set(dict1.keys()).union(dict2.keys()):
        if k in dict1 and k in dict2:
            if isinstance(dict1[k], dict) and isinstance(dict2[k], dict):
                yield (k, dict(mergedicts(dict1[k], dict2[k])))
            else:
                yield (k, dict2[k])
        elif k in dict1:
            yield (k, dict1[k])
        else:
            yield (k, dict2[k])


def mergedicts(dict1, dict2):
    result = {}
    for k in set(dict1.keys()).union(dict2.keys()):
        if k in dict1 and k in dict2:
            if isinstance(dict1[k], dict) and isinstance(dict2[k], dict):
                result[k] = mergedicts(dict1[k], dict2[k])
            else:
                result[k] = dict2[k]
        elif k in dict1:
            result[k] = dict1[k]
        else:
            result[k] = dict2[k]
    return result


class YAMLDumper(yaml.Dumper):
    def increase_indent(self, flow=False, indentless=False):
        return super(YAMLDumper, self).increase_indent(flow, False)
    pass


YAMLDumper.add_representer(str, yaml.representer.SafeRepresenter.represent_str)
YAMLDumper.add_representer(unicode, yaml.representer.SafeRepresenter.represent_unicode)
