# -*- coding: utf-8 -*-

import urllib

from sandbox.projects import resource_types

from sandbox.projects.common.pumpkin import serp_task
from sandbox.projects.common.pumpkin import parameters as pumpkin_params


_PUMPKIN_CGI_PARAMS = "promo=pumpkin"
_NO_HEADER_PARAMS = "no_header=1"
_NONEXISTENT_SITE = "nonexistent-5be495e5.com"
_MEANINGLESS_QUERY = "sdgags"


class TouchBuildPumpkinSerp(serp_task.BaseBuildPumpkinSerpTask):
    type = "TOUCH_BUILD_PUMPKIN_SERP"

    INDEX_RESOURCE_TYPE = resource_types.PUMPKIN_INDEX
    ARCHIVE_RESOURCE_TYPE = resource_types.PUMPKIN_INDEX_ARCHIVE

    def do_before_execute_on_test_server(self):
        self.ctx[pumpkin_params.DisregardTime.name] = True

    def _make_production_attributes(self, domain):
        if domain == serp_task.RU_DOMAIN:
            return ("production_tag", "1")
        else:
            return ("production_tag_{}".format(domain), "1")

    def _make_serp_url(self, domain, text):
        return "{0}/touchsearch?text={1}&{2}".format(self._make_url(domain),
                urllib.quote(text), _PUMPKIN_CGI_PARAMS)

    def _make_serp_url_without_header(self, domain, text):
        return "{0}/touchsearch?text={1}&{2}&{3}".format(self._make_url(domain),
                urllib.quote(text), _PUMPKIN_CGI_PARAMS, _NO_HEADER_PARAMS)

    def _make_main_page_url(self, domain):
        return None

    def _make_notfound_page_url(self, domain):
        return "{0}/touchsearch?text={1}%20site:{2}&{3}&{4}".format(self._make_url(domain),
                urllib.quote(_MEANINGLESS_QUERY),
                _NONEXISTENT_SITE,
                _PUMPKIN_CGI_PARAMS,
                self.ctx[pumpkin_params.AddCGIParams.name])

    def _make_notfound_page_url_without_header(self, domain):
        # need to add AddCGIParams which contains cgi parameter exp_flags=pumpkin
        # because header delimeter is available only for pumpkin queries
        return "{0}/touchsearch?text={1}%20site:{2}&{3}&{4}&{5}".format(self._make_url(domain),
                urllib.quote(_MEANINGLESS_QUERY),
                _NONEXISTENT_SITE,
                _PUMPKIN_CGI_PARAMS,
                self.ctx[pumpkin_params.AddCGIParams.name],
                _NO_HEADER_PARAMS)

    def _make_url(self, domain):
        url = serp_task.BaseBuildPumpkinSerpTask._make_url(self, domain)
        if url is not None:
            return url

        if domain == serp_task.RU_DOMAIN:
            return "https://yandex.ru"
        else:
            return "https://yandex.com.tr"

    def _make_test_task(self, urls_resource_id, serps_resource_id):
        from projects.TouchTestPumpkinSerp import TouchTestPumpkinSerp
        from projects.TouchTestPumpkinSerp import UrlsResourceParameter
        from projects.TouchTestPumpkinSerp import SerpsResourceParameter

        sub_ctx = {
            UrlsResourceParameter.name: urls_resource_id,
            SerpsResourceParameter.name: serps_resource_id
        }
        sub_task = self.create_subtask(
            task_type=TouchTestPumpkinSerp.type,
            input_parameters=sub_ctx,
            description=self.descr,
            execution_space=self.execution_space
        )
        return sub_task.id


__Task__ = TouchBuildPumpkinSerp
