from sandbox import sdk2
from sandbox.projects.common.nanny import nanny
import json

import sandbox.common.types.task as ctt


class ConfigJson(sdk2.Resource):
    """  resource  """
    releasable = True


class ResultResourceType1(sdk2.Resource):
    """  resource  """
    releasable = True


class ResultResourceType2(sdk2.Resource):
    """  resource  """
    releasable = True


class ResultResourceType3(sdk2.Resource):
    """  resource  """
    releasable = True


class ResultResourceType4(sdk2.Resource):
    """  resource  """
    releasable = True


class ResultResourceType5(sdk2.Resource):
    """  resource  """
    releasable = True


class ResultResourceType6(sdk2.Resource):
    """  resource  """
    releasable = True


class ResultResourceType7(sdk2.Resource):
    """  resource  """
    releasable = True


class ResultResourceType8(sdk2.Resource):
    """  resource  """
    releasable = True


class CreateTrainingConfigJson(nanny.ReleaseToNannyTask2, sdk2.Task):
    """ MARTY-3332 """

    class Parameters(sdk2.Parameters):
        subject_name = sdk2.parameters.String("Subject Name", default="Marty test release", required=True)
        # prepare
        fail_resource = sdk2.parameters.Bool("Fail_resource")
        fail_prepare = sdk2.parameters.Bool("Fail_prepare")
        prepare_time = sdk2.parameters.Integer("Prepare_time")
        # start
        start_time = sdk2.parameters.Integer("Start_time")
        fail_start = sdk2.parameters.Bool("Fail_start")
        status_time = sdk2.parameters.Integer("Status_time")
        fail_status = sdk2.parameters.Bool("Fail_status")
        fail_resource_timeout = sdk2.parameters.Integer("Fail_resource_timeout")
        change_port = sdk2.parameters.Bool("Change_port")
        change_location = sdk2.parameters.Bool("Change_location")
        change_response = sdk2.parameters.Bool("Change_response")
        delete_resource = sdk2.parameters.Bool("delete_resource")
        # resources
        res_config = sdk2.parameters.Bool("Config file")
        res_1 = sdk2.parameters.Bool("Result resource 1")
        res_2 = sdk2.parameters.Bool("Result resource 2")
        res_3 = sdk2.parameters.Bool("Result resource 3")
        res_4 = sdk2.parameters.Bool("Result resource 4")
        res_5 = sdk2.parameters.Bool("Result resource 5")
        res_6 = sdk2.parameters.Bool("Result resource 6")
        res_7 = sdk2.parameters.Bool("Result resource 7")
        res_8 = sdk2.parameters.Bool("Result resource 8")

    def on_execute(self):
        if self.Parameters.res_config:
            config = sdk2.ResourceData(ConfigJson(self, "TrainingJson", "ConfigJson"))
            list_parameters = ["fail_resource",
                               "fail_prepare",
                               "prepare_time",
                               "start_time",
                               "fail_start",
                               "status_time",
                               "fail_status",
                               "fail_resource_timeout",
                               "change_port",
                               "change_location",
                               "change_response",
                               "delete_resource"]
            result_data = dict()
            for parameter in list_parameters:
                result_data[parameter] = getattr(self.Parameters, parameter)
            config.path.write_bytes(json.dumps(result_data))
            config.ready()

        resources = (self.Parameters.res_1, self.Parameters.res_2, self.Parameters.res_3, self.Parameters.res_4, self.Parameters.res_5, self.Parameters.res_6, self.Parameters.res_7, self.Parameters.res_8)
        res_types = (ResultResourceType1, ResultResourceType2, ResultResourceType3, ResultResourceType4, ResultResourceType5, ResultResourceType6, ResultResourceType7, ResultResourceType8)
        for resource, res_type, index in zip(resources, res_types, range(1, len(resources) + 1)):
            if not resource:
                continue
            res_type_name = res_type.__name__
            res = sdk2.ResourceData(res_type(self, res_type_name, res_type_name))
            res.path.write_bytes(json.dumps('res{}'.format(index)))
            res.ready()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
    
    def on_success(self, prev_status):
        sdk2.Task.on_success(self, prev_status)
        nanny.ReleaseToNannyTask2.on_release(self, dict(
            releaser=self.author,
            release_status=ctt.ReleaseStatus.STABLE,
            release_subject=self.Parameters.subject_name,
            email_notifications=dict(to=[], cc=[]),
            release_comments="Rollin' some release around",
        ))
