from sandbox import sdk2
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.build.YaMake2 import YaMake2

import sandbox.common.types.task as ctt


class MartyTestResource(sdk2.Resource):
    any_arch = True
    auto_backup = False
    executable = False
    releasable = True
    ttl = 3


class MartyTestReleaseTask(nanny.ReleaseToNannyTask2, YaMake2):
    def on_success(self, prev_status):
        sdk2.Task.on_success(self, prev_status)
        nanny.ReleaseToNannyTask2.on_release(self, dict(
            releaser=self.author,
            release_status=ctt.ReleaseStatus.STABLE,
            release_subject="Marty test release",
            email_notifications=dict(to=[], cc=[]),
            release_comments="Rollin' some release around",
        ))
