# coding: utf-8
from sandbox import sdk2

from . import dicts
from . import releasers


class PORTO_LAYER_HOTELS_JAVA(sdk2.Resource):
    """
        Общий Porto слой для Java-based сервисов новых Отелей Путешествий
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class PORTO_LAYER_TRAVEL_HOTELS_OFFERCACHE(sdk2.Resource):
    """
        Porto слой для OfferCache
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class PORTO_LAYER_TRAVEL_COMMON(sdk2.Resource):
    """
        Общий Porto слой для (legacy) сервисов Путешествий.
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class PORTO_LAYER_TRAVEL_TEAMCITY(sdk2.Resource):
    """
        Teamcity Porto слой для Путешествий.
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_OFFERCACHE_BINARY(sdk2.Resource):
    """
        Бинарник очень нового серпового колдущика Путешествий.
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTEL_SEARCHER_BINARY(sdk2.Resource):
    """
        Бинарник нового Отельного поиска Путешествий.
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_REDIR_BINARY(sdk2.Resource):
    """
        Бинарник Редиректилки
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_BOILER_BINARY(sdk2.Resource):
    """
        Бинарник кипятильника
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_DUMMY_SERVICE_PACKAGE(sdk2.Resource):
    """
        Тестовый сервис.
    """
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTEL_PARTNER_MOCK_BINARY(sdk2.Resource):
    """
        Бинарник партнерской мокалки Отельного поиска Путешествий.
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_API_BINARY(sdk2.Resource):
    """
        Бинарник API Путешествий.
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS + releasers.RELEASERS_AVIA + releasers.RELEASERS_TRAINS + releasers.RELEASERS_RASP


class TRAVEL_API_REQ_REPLICATOR_BINARY(sdk2.Resource):
    """
        Бинарник репликатора нагрузки API Путешествий.
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS + releasers.RELEASERS_AVIA + releasers.RELEASERS_TRAINS


class TRAVEL_ORDERS_APP_BINARY(sdk2.Resource):
    """
        Бинарник сервиса оркестрации заказов.
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS + releasers.RELEASERS_TRAINS + releasers.RELEASERS_AVIA + releasers.RELEASERS_RASP


class TRAVEL_DEVOPS_SLACK_BINARY(sdk2.Resource):
    """
        Бинарник сервиса форвардинга слак-сообщений
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_DUMMY_NIRVANA_INTEGRATION_BINARY(sdk2.Resource):
    """
        Тестовый бинарник для проверки интеграции с Нирваной и Хитманом
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_FEAGEN_SLOW_GEOSEARCH(sdk2.Resource):
    """
        Бинарник для подсчёта факторов Геопоиска
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_FEAGEN_SLOW_MEDIANPRICE(sdk2.Resource):
    """
        Бинарник для подсчёта медианной цены отелей, регионов как факторов для геопоиска
    """
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_FEAGEN_MINPRICE(sdk2.Resource):
    """
        Бинарник для предрасчёта аггрегатов минимальных цен за ночь по дням заезда поотельно
    """
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_PRICE_STATS(sdk2.Resource):
    """
        Бинарник для расчёта аггрегатов цен за различные периоды времени
        для псевдоскидок и расчёта величин для контроля качества показа псевдоскидок
    """
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_FEAGEN_INTERACTIVE_SEARCHES(sdk2.Resource):
    """
        Бинарник для расчёта поотельно количеств интерактивных поисков пользователями из колдунщиков 1орг,
        оргмн и поисков их как похожих при интерактивных поисках
    """
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_EXPEDIAPROVIDER_BINARY(sdk2.Resource):
    """
        Бинарник провайдера бронирований экспедии.
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_FEAGEN_SLOW_BOOKING(sdk2.Resource):
    """
        Бинарник для подсчёта факторов Геопоиска, связанных с Booking.com
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_FEAGEN_MERGER(sdk2.Resource):
    """
        Бинарник для объединения всех факторов в одну таблицу
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_BUILD_ALTAY_MAPPINGS_BINARY(sdk2.Resource):
    """
        Бинарник тулзы построения отельный маппингов по алтаю
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_CPA_MERGE_TRAIN_REFUNDS(sdk2.Resource):
    """
        Бинарник для объединенния LF таблиц возвратов ЖД и записи их в итоговую таблицу для аналитики
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_CPA


class TRAVEL_HOTELS_FEEDERS(sdk2.Resource):
    """
        Feeders Package
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_FEAGEN_SLOW_AVAILABILITY_PR(sdk2.Resource):
    """
        Бинарник для подсчёта фактора вероятности наличия предложений для отеля
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_PRICECHECKER_BINARY(sdk2.Resource):
    """
        Бинарник сервиса для проверки неизменности цен после перехода
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_CPA_COLLECTORS(sdk2.Resource):
    """
        Объединённый бинарник коллекторов для CPA-платформы
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_CPA


class TRAVEL_HOTELS_COLD_BINARY(sdk2.Resource):
    """
        Бинарник для построения таблицы COLD
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_CATROOM_STAT_BINARY(sdk2.Resource):
    """
        Бинарник для построения статистики катрума
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_CPA_CALC_ORDERS_LAG(sdk2.Resource):
    """
        Бинарник для рассчёта лага формирования заказов (CPA-платформа)
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_CPA


class TRAVEL_CPA_REBUILD_ORDERS(sdk2.Resource):
    """
        Бинарник для повторной отправки заказов в очередь обработки (CPA-платформа)
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_CPA


class TRAVEL_CPA_UPDATE_ORDERS_INCREMENTAL(sdk2.Resource):
    """
        Бинарник для инкрементального объединения снэпшотов в заказы (CPA-платформа)
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_CPA


class TRAVEL_FEEDS_REPORT_BINARY(sdk2.Resource):
    """
        Бинарник отчета по фидам
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_CPA_RECONCILIATION(sdk2.Resource):
    """
        Бинарник для автоматической сверки (CPA-платформа)
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_CPA


class TRAVEL_PRICE_CATEGORY_PRECALC_BINARY(sdk2.Resource):
    """
        Бинарник скрипта подготовки логов для рассчета ценовых категорий
        см. TRAVEL_PRICE_CATEGORY_BINARY для основного рассчета
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_PRICE_CATEGORY_BINARY(sdk2.Resource):
    """
        Бинарник скрипта рассчета ценовых категорий
        см. TRAVEL_PRICE_CATEGORY_PRECALC_BINARY для рассчета аггрегирующего поисковые логи
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_CONTENT_MANAGER_PROCESSORS(sdk2.Resource):
    """
        Бинарник процессоров (контент-платформа)
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_CONTENT_MANAGER_EXEC(sdk2.Resource):
    """
        Бинарник управляющего контура (контент-платформа)
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_EXPERIMENTAL_OC(sdk2.Resource):
    """
        Экспериментальный бинарник офферкеша
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_ORDERS_APP_CONFIG_TESTING(sdk2.Resource):
    """
        Файлы конфигураций для testing окружения сервиса заказов
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_ORDERS_APP_CONFIG_PROD(sdk2.Resource):
    """
        Файлы конфигураций для prod окружения сервиса заказов
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_ORDERS_APP_CONFIG_STRESS(sdk2.Resource):
    """
        Файлы конфигураций для нагрузочного окружения сервиса заказов
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_API_CONFIG(sdk2.Resource):
    """
        Файлы конфигураций для сервиса api
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS + releasers.RELEASERS_AVIA + releasers.RELEASERS_TRAINS


class TRAVEL_ORDERS_APP_CONFIG(sdk2.Resource):
    """
        Файлы конфигураций для сервиса заказов
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_GEOCOUNTER_BINARY(sdk2.Resource):
    """
        Бинарник сервиса статистики по отелям для портала Путешествий.
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_BUILD_GEOCOUNTER_DATA_BINARY(sdk2.Resource):
    """
        Бинарник тулзы построения отельный маппингов по алтаю
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_BUILD_HOTEL_TRAITS_BINARY(sdk2.Resource):
    """
        Бинарник тулзы для сбора данных отельных признаков
        HOTELS-4371
        HOTELS-4366
        HOTELS-4367
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_PRICE_FILTER_DATA_BINARY(sdk2.Resource):
    """
        Бинарник тулзы для фильтра по цене в базовом геопоиска
        HOTELS-4633
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_BOY_CATROOM_BUILDER_BINARY(sdk2.Resource):
    """
        Построение индекса catroom для BoY партнеров
        HOTELS-4707
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_ADMINISTRATOR_BINARY(sdk2.Resource):
    """
        Бинарник Администратора отелей
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_EXTERNAL_API_BINARY(sdk2.Resource):
    """
        Бинарник внешнего API
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS + releasers.RELEASERS_MARKETING


class TRAVEL_HOTELS_SANDBOX_PLANNER_BINARY(sdk2.Resource):
    """
        Бинарник планировщика
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_CFG_TOOL_BINARY(sdk2.Resource):
    """
        Бинарник конфигуратора
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS + releasers.RELEASERS_MARKETING


class TRAVEL_HOTELS_SLUG_BUILDER_BINARY(sdk2.Resource):
    """
        Бинарник построителя индекса SLUG-ов отелей
        TRAVELBACK-119
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_SITEMAP_BUILDER_BINARY(sdk2.Resource):
    """
        Бинарник построителя sitemap-а отелей
        TRAVELBACK-324
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_TELLER_APP_BINARY(sdk2.Resource):
    """
        Бинарник сервиса Teller (Транзакционный учёт)
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_EXPEDIA_PROPERTY_PANSIONS_BUILDER_BINARY(sdk2.Resource):
    """
        Бинарник построителя информации о питании уровня отеля от Expedia
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_SUGGEST_BUILD_PIPELINE(sdk2.Resource):
    """
    Пакет с бинарниками для сборки словаря саджеста
    TRAVELBACK-406
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_SUGGEST_METRICS_BUILDER(sdk2.Resource):
    """
    Бинарник для рассчета метрик саджеста
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_PERMAROOM_BUILDER_BINARY(sdk2.Resource):
    """
        Бинарник построителя информации о номерах в отелях
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_RUN_YQL_BINARY(sdk2.Resource):
    """
        Бинарник универсального запускателя YQL
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_ORDERS_TO_METRIKA_BINARY(sdk2.Resource):
    """
        Бинарник выгружателя заказов в метрику
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_BOY_CHECKER(sdk2.Resource):
    """
        Бинарник batch-чекалки BoY-отелей (ParityCheck etc)
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_CHECKER_TG_BOT(sdk2.Resource):
    """
        Бинарник TG-ботика Проверятора
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_ROOM_PHOTOS_UPLOADER(sdk2.Resource):
    """
        Бинарник загружатора фотографий комнат в аватарницу
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_CPA_FLOW_APP(sdk2.Resource):
    """
        Бинарник приложения потоковой обработки данных (CPA-платформа)
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_CPA


class TRAVEL_HOTELS_REGION_PAGES_RENDERER(sdk2.Resource):
    """
        Бинарник шаблонизатора для страниц регионов
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS + releasers.RELEASERS_RASP


class TRAVEL_HOTELS_REGION_PAGES_DATA_MINER(sdk2.Resource):
    """
        Бинарник сборщика данных для страниц регионов
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS + releasers.RELEASERS_RASP


class TRAVEL_HOTELS_PORTAL_POLLING_LOGS_BUILDER(sdk2.Resource):
    """
        Бинарник построителя логов поллинга отелей на портале
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_RASP_DICTS_UPLOADER(sdk2.Resource):
    """
        Бинарник тулзы, загружающей словари RASP-ов в НЕ
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS + releasers.RELEASERS_AVIA


class TRAVEL_HOTELS_PAGE_SPEED_DATA_DOWNLOADER(sdk2.Resource):
    """
        Бинарник скрипта аналитиков для опроса Google Page Speed API
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_MARKETING_FEED_BUILDER(sdk2.Resource):
    """
        Бинарник скрипта аналитиков построения маркетингового фида
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_MODERATOR_TG_BOT(sdk2.Resource):
    """
        Бинарник TG-ботика Модератора
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_PORTAL_PERMAROOM_LOGS_BUILDER(sdk2.Resource):
    """
        Бинарник построителя логов пермарумов на портале
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_BUSBROKER_BINARY(sdk2.Resource):
    """
        Бинарник сервиса записи событий в offerbus (в частности - инвалидации офферов)
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_DATASET_PRICES_BUILDER(sdk2.Resource):
    """
        Бинарник построителя датасетов цен
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_SPYT_RUNNER(sdk2.Resource):
    """
        Бинарник запускателя процессов построения данных в spark over yt
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_MARKETING_CONTENT_ADMIN_BINARY(sdk2.Resource):
    """
        Бинарник контентной админки
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_RASP + releasers.RELEASERS_AVIA


class TRAVEL_MARKETING_CONTENT_BACKEND_BINARY(sdk2.Resource):
    """
        Бинарник контентного бэкенда
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_RASP + releasers.RELEASERS_AVIA


class TRAVEL_TANKER_TO_YT_DUMPER(sdk2.Resource):
    """
        Бинарник тулзы для дампа данных из Tanker в YT
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_BUSES + releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_DATASET_CURATOR(sdk2.Resource):
    """
        Бинарник хранителя датасетов
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS + releasers.RELEASERS_RASP


class TRAVEL_SANDBOX_TO_S3_DICTS_DUMPER(sdk2.Resource):
    """
        Бинарник тулзы для дампа справочников из Sandbox в S3
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_BUSES + releasers.RELEASERS_TRAINS + releasers.RELEASERS_RASP + releasers.RELEASERS_AVIA


class TRAVEL_TRAINS_BANDIT_API_PACKAGE(sdk2.Resource):
    """
        Ресурс с архивом полученным в результате сборки /travel/rasp/train_bandit_api
    """
    executable = False
    releasable = True
    releasers = releasers.RELEASERS_TRAINS


class TRAVEL_TRAINS_SEARCH_API_PACKAGE(sdk2.Resource):
    """
        Ресурс с архивом полученным в результате сборки /travel/trains/search_api
    """
    executable = False
    releasable = True
    releasers = releasers.RELEASERS_TRAINS + releasers.RELEASERS_WIZARDS


class TRAVEL_TRAINS_TEMPLATES_DUMPER_PACKAGE(sdk2.Resource):
    """
        Ресурс tarball с бинарником /travel/trains/search_api/cmd/templates_dumper
    """
    executable = False
    releasable = True
    releasers = releasers.RELEASERS_TRAINS


class TRAVEL_TRAINS_WORKER_PACKAGE(sdk2.Resource):
    """
        Ресурс с архивом полученным в результате сборки /travel/trains/worker
    """
    executable = False
    releasable = True
    releasers = releasers.RELEASERS_TRAINS

class TRAVEL_HOTELS_TUGC_PACKAGE(sdk2.Resource):
    """
        Бинарник TUGC
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_EXPEDIA_MAIL_PARSER_BINARY(sdk2.Resource):
    """
        Бинарник получения и сохранения отчетов агентта от Expedia
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_EXPEDIA_ORDERS_LOG_BUILDER_BINARY(sdk2.Resource):
    """
        Бинарник построителя лога событий по письмам от Expedia
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_EXPEDIA_ORDERS_LOG_PARSER_BINARY(sdk2.Resource):
    """
        Бинарник построителя информации о суммах комиссии от Expedia
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_AFFILIATE_DATA_BUILDER(sdk2.Resource):
    """
        Бинарник подготовки данных для партнёрской программы
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS + releasers.RELEASERS_MARKETING


class TRAVEL_MARKETING_FEED_TRAINS_BUILDER(sdk2.Resource):
    """
        Бинарник подготовки маркетингового фида для ЖД
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_SMART_BANNER_FEED_TRAINS_BUILDER(sdk2.Resource):
    """
        Бинарник подготовки фида для карусели (smart-banner) для ЖД
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_TRAINS


class TRAVEL_HOTELS_BUDAPEST_ACTIVATOR(sdk2.Resource):
    """
        Бинарник битрикс-активатора Будапешта
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_BUDAPEST_IMPORTER(sdk2.Resource):
    """
        Бинарник экспортер данных из битрикса Будапешта
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_BUDAPEST_IMPORTER_V2(sdk2.Resource):
    """
        Бинарник экспортер данных из битрикса Будапешта (v2)
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_BUDAPEST_PROMO_TOOL_V2(sdk2.Resource):
    """
        Пакет с Бинарником и Конфигом ассайнера промокодов для Будапешта (v2)
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_GOOGLE_LIST_GENERATOR(sdk2.Resource):
    """
        Бинарник генератора списка отелей для google hotels
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS + releasers.RELEASERS_MARKETING


class TRAVEL_MARKETING_PERFLUENCE_STATISTIC_BUILDER(sdk2.Resource):
    """
        Бинарник сборки статистики по заказам с промокодами Perfluence
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_MARKETING


class TRAVEL_APP_BACKEND_PACKAGE(sdk2.Resource):
    """
        Бинарник backend-сервиса мобильного приложения
    """
    auto_backup = True
    releasable = True
    executable = False
    ttl = 'inf'
    releasers = releasers.RELEASERS_APP


class TRAVEL_CLEAN_SANDBOX_RESOURCES(sdk2.Resource):
    """
        Бинарник для очистки ресурсов Sandbox
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_APP_BACKEND_SERVER_CONFIG(sdk2.Resource):
    """
        Серверный конфиг мобильного приложения
    """
    auto_backup = True
    releasable = True
    executable = False
    ttl = 'inf'
    releasers = releasers.RELEASERS_APP


class TRAVEL_EXPEDIA_MARKETING_EXPENSES_BUILDER(sdk2.Resource):
    """
        Бинарник для построения отчёта о маркетинговых расходах по заказам Экспедии
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_MARKETING_LOTOTRON(sdk2.Resource):
    """
        Бинарник для определения победителей акции Чёрная пятница
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_MARKETING + releasers.RELEASERS_HOTELS


class TRAVEL_APP_BACKEND_L10N_DATA(sdk2.Resource):
    """
        Импортированные из танкера данные локализации приложения путешествий
    """
    auto_backup = True
    releasable = True
    executable = False
    ttl = 'inf'
    releasers = releasers.RELEASERS_APP


class TRAVEL_APP_BACKEND_L10N_IMPORTER(sdk2.Resource):
    """
        Бинарник импортера данных локализации приложения путешествий
    """
    auto_backup = True
    releasable = True
    executable = False
    ttl = 'inf'
    releasers = releasers.RELEASERS_APP

class TRAVEL_BUDAPEST_ROOMS_BACKEND_BINARY(sdk2.Resource):
    """
        Сброка приложения rooms-backend, проект Будапешт.
    """
    auto_backup = True
    releasable = True
    executable = False
    ttl = 'inf'
    releasers = releasers.RELEASERS_BUDAPEST

class TRAVEL_BUDAPEST_ROOMS_MIGRATION_DB_BINARY(sdk2.Resource):
    """
        Утилита миграция схемы в базах данных сайта rooms
    """
    auto_backup = True
    releasable = True
    executable = False
    ttl = 'inf'
    releasers = releasers.RELEASERS_BUDAPEST

class TRAVEL_BUDAPEST_PMS_SYNCHRONIZER(sdk2.Resource):
    """
        Бинарник синхронизатора данных meta-pms будапешта
    """
    auto_backup = True
    releasable = True
    executable = False
    ttl = 'inf'
    releasers = releasers.RELEASERS_BUDAPEST


class TRAVEL_BUDAPEST_PMS_NOTIFIER(sdk2.Resource):
    """
        Бинарник нотификатора meta-pms будапешта
    """
    auto_backup = True
    releasable = True
    executable = False
    ttl = 'inf'
    releasers = releasers.RELEASERS_BUDAPEST


class TRAVEL_BUDAPEST_PMS_ACTIVATOR(sdk2.Resource):
    """
        Бинарник активатора meta-pms будапешта
    """
    auto_backup = True
    releasable = True
    executable = False
    ttl = 'inf'
    releasers = releasers.RELEASERS_BUDAPEST


class TRAVEL_BUDAPEST_PMS_TGBOT(sdk2.Resource):
    """
        Бинарник телеграмм-бота meta-pms будапешта
    """
    auto_backup = True
    releasable = True
    executable = False
    ttl = 'inf'
    releasers = releasers.RELEASERS_BUDAPEST


class TRAVEL_BUDAPEST_PMS_STATUS_TRIGGER(sdk2.Resource):
    """
        Бинарник cmd-утилиты для отправки статус-событий в meta-pms будапешта
    """
    auto_backup = True
    releasable = True
    executable = False
    ttl = 'inf'
    releasers = releasers.RELEASERS_BUDAPEST


class TRAVEL_MARKETING_NOTIFY_NOT_FINISHED_SEARCHES_TRAINS(sdk2.Resource):
    """
        Бинарник для боршенных поисков ЖД
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_MARKETING + releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_PROMOGRANTER_BINARY(sdk2.Resource):
    """
        Бинарник сервиса распределения баллов плюса по внешним для оркестратора заказам
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS


class TRAVEL_HOTELS_EXTRANET(sdk2.Resource):
    """
        Бинарник отельного экстранета.
    """
    auto_backup = True
    releasable = True
    releasers = releasers.RELEASERS_HOTELS
