# coding: utf8
from __future__ import absolute_import, division, print_function

import inspect

from sandbox import sdk2

from . import releasers


class TRAVEL_DICT_BASE(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = None
    is_common_dict = False


class TRAVEL_DICT_AVIA_BASE(TRAVEL_DICT_BASE):
    releasers = releasers.RELEASERS_HOTELS + releasers.RELEASERS_AVIA


class TRAVEL_DICT_RASP_BASE(TRAVEL_DICT_BASE):
    releasers = releasers.RELEASERS_TRAINS + releasers.RELEASERS_RASP
    resource_name = None
    build_type = sdk2.parameters.String("Build type")
    platform = sdk2.parameters.String("Platform")


class TRAVEL_DICT_RASP_COMMON_DICT_BASE(TRAVEL_DICT_RASP_BASE):
    is_common_dict = True


class TRAVEL_DICT_AVIA_FARE_FAMILIES_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник семейств тарифов авиакомпаний от Авиа"""
    resource_name = 'fare_families'


class TRAVEL_DICT_AVIA_SETTLEMENTS_TESTING(TRAVEL_DICT_AVIA_BASE):
    """Справочник населённых пунктов от Авиа"""


class TRAVEL_DICT_AVIA_AIRPORTS_TESTING(TRAVEL_DICT_AVIA_BASE):
    """Справочник аэропортов от Авиа"""


class TRAVEL_DICT_AVIA_AIRLINES_TESTING(TRAVEL_DICT_AVIA_BASE):
    """Справочник авиакомпаний от Авиа"""


class TRAVEL_DICT_AVIA_AIRPORTS_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник аэропортов от Авиа"""


class TRAVEL_DICT_AVIA_AIRLINES_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник авиакомпаний от Авиа"""


class TRAVEL_DICT_AVIA_AVIA_COMPANY_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник авиа-компаний от Авиа"""
    resource_name = 'avia_company'
    is_common_dict = True


class TRAVEL_DICT_AVIA_NEAR_DIRECTION_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник радиусов для поиска ближайших городов к городу прибытия от Авиа"""
    resource_name = 'near_direction'


class TRAVEL_DICT_AVIA_CITY_MAJORITY_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник величин городов от Авиа"""
    resource_name = 'city_majority'
    is_common_dict = True


class TRAVEL_DICT_AVIA_CODE_SYSTEM_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник кодовых систем от Авиа"""
    resource_name = 'code_system'
    is_common_dict = True


class TRAVEL_DICT_AVIA_COMPANY_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник компаний от Авиа"""
    resource_name = 'company'
    is_common_dict = True


class TRAVEL_DICT_AVIA_COMPANY_TARIFF_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник тарифов компаний от Авиа"""
    resource_name = 'company_tariff'
    is_common_dict = True


class TRAVEL_DICT_AVIA_COUNTRY_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник стран от Авиа"""
    resource_name = 'country'
    is_common_dict = True


class TRAVEL_DICT_AVIA_CURRENCY_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник валют от Авиа"""
    resource_name = 'currency'
    is_common_dict = True


class TRAVEL_DICT_AVIA_FLIGHT_SCHEDULE_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник авиа-расписаний от Авиа"""
    resource_name = 'flight_schedule'


class TRAVEL_DICT_AVIA_IATA_CORRECTION_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник иата-коррекций от Авиа"""
    resource_name = 'iata_correction'
    is_common_dict = True


class TRAVEL_DICT_AVIA_REGION_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник регионов от Авиа"""
    resource_name = 'region'
    is_common_dict = True


class TRAVEL_DICT_AVIA_POINT_SYNONYM(TRAVEL_DICT_AVIA_BASE):
    """Справочник синонимов для точек"""
    resource_name = 'point_synonym'
    is_common_dict = True


class TRAVEL_DICT_AVIA_SETTLEMENT_BIG_IMAGE_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник логотипов городов от Авиа"""
    resource_name = 'settlement_big_image'
    is_common_dict = True


class TRAVEL_DICT_AVIA_SETTLEMENTS_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник населённых пунктов от Авиа"""
    resource_name = 'settlements'
    is_common_dict = True


class TRAVEL_DICT_AVIA_STATION_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник станций от Авиа"""
    resource_name = 'station'
    is_common_dict = True


class TRAVEL_DICT_AVIA_STATION_TO_SETTLEMENT_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник станций в населенных пунктах от Авиа"""
    resource_name = 'station_to_settlement'
    is_common_dict = True


class TRAVEL_DICT_AVIA_STATION_CODE_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник кодов станций от Авиа"""
    resource_name = 'station_code'
    is_common_dict = True


class TRAVEL_DICT_AVIA_TRANSLATED_TITLE_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник переводов от Авиа"""
    resource_name = 'translated_title'
    is_common_dict = True


class TRAVEL_DICT_AVIA_TOP_FLIGHT_PROD(TRAVEL_DICT_AVIA_BASE):
    """Справочник переводов от Авиа"""
    resource_name = 'top_flight'


class TRAVEL_DICT_RASP_AVIAALLIANCE_PROD(TRAVEL_DICT_RASP_BASE):
    """Справочник авиа альянсов"""
    resource_name = 'aviaalliance'


class TRAVEL_DICT_RASP_CARRIER_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник авиакомпаний"""
    resource_name = 'carrier'


class TRAVEL_DICT_RASP_COUNTRY_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник стран"""
    resource_name = 'country'


class TRAVEL_DICT_RASP_CURRENCY_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник валют"""
    resource_name = 'currency'


class TRAVEL_DICT_RASP_DISTRICT_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник округов"""
    resource_name = 'district'


class TRAVEL_DICT_RASP_EXPRESS_TO_COUNTRY_PROD(TRAVEL_DICT_RASP_BASE):
    """Справочник соотношений экспресс кодов к странам"""
    resource_name = 'express_to_country'


class TRAVEL_DICT_RASP_NAMED_TRAIN_PROD(TRAVEL_DICT_RASP_BASE):
    """Справочник именнованных поездов"""
    resource_name = 'named_train'


class TRAVEL_DICT_RASP_POINTSYNONYM_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник синонимов"""
    resource_name = 'pointsynonym'


class TRAVEL_DICT_RASP_READABLE_TIMEZONE_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник временных зон"""
    resource_name = 'readable_timezone'


class TRAVEL_DICT_RASP_REGION_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник регионов"""
    resource_name = 'region'


class TRAVEL_DICT_RASP_ROUTE_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник общих данных по ниткам"""
    resource_name = 'route'


class TRAVEL_DICT_RASP_SETTLEMENT_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник населенных пунктов"""
    resource_name = 'settlement'


class TRAVEL_DICT_RASP_SETTLEMENT_TO_STATION_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник отношений населенных пунктов к станциям"""
    resource_name = 'settlement2station'


class TRAVEL_DICT_RASP_STATION_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник станций"""
    resource_name = 'station'


class TRAVEL_DICT_RASP_STATION_CODE_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник кодов станций (например express, iata, sirena)"""
    resource_name = 'station_code'


class TRAVEL_DICT_RASP_STATION_EXPRESS_ALIAS_PROD(TRAVEL_DICT_RASP_BASE):
    """Справочник названий станций в системе Экспресс"""
    resource_name = 'station_express_alias'


class TRAVEL_DICT_RASP_STATION_TO_SETTLEMENT_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник отношений станций к населенным пунктов"""
    resource_name = 'station_to_settlement'


class TRAVEL_DICT_RASP_SUPPLIER_PROD(TRAVEL_DICT_RASP_BASE):
    """Справочник поставщиков данных"""
    resource_name = 'supplier'


class TRAVEL_DICT_RASP_THREAD_PROD(TRAVEL_DICT_RASP_BASE):
    """Справочник ниток"""
    resource_name = 'thread'


class TRAVEL_DICT_RASP_THREAD_STATION_PROD(TRAVEL_DICT_RASP_BASE):
    """Справочник отношений станций к ниткам"""
    resource_name = 'thread_station'


class TRAVEL_DICT_RASP_THREAD_TARIFF_PROD(TRAVEL_DICT_RASP_BASE):
    """Справочник отношений тарифов к ниткам"""
    resource_name = 'thread_tariff'


class TRAVEL_DICT_RASP_THREAD_TITLE_PROD(TRAVEL_DICT_RASP_BASE):
    """Справочник названий ниток"""
    resource_name = 'thread_title'


class TRAVEL_DICT_RASP_TIMEZONE_PROD(TRAVEL_DICT_RASP_COMMON_DICT_BASE):
    """Справочник временных зон"""
    resource_name = 'timezone'


class TRAVEL_DICT_RASP_TRAIN_TARIFFINFO_PROD(TRAVEL_DICT_RASP_BASE):
    """Справочник тарифов на поезда"""
    resource_name = 'train_tariffinfo'


class TRAVEL_DICT_RASP_TRANSPORT_PROD(TRAVEL_DICT_RASP_BASE):
    """Справочник типов транспортов"""
    resource_name = 'thread_transport'


class TRAVEL_DICT_RASP_TRANSPORT_MODEL_PROD(TRAVEL_DICT_RASP_BASE):
    """Справочник моделей транспортов"""
    resource_name = 'transport_model'


class TRAVEL_RASP_COMMON_DICTS_BUNDLE(TRAVEL_DICT_BASE):
    """Архив с общими справочниками"""
    resource_name = 'common_dicts'


class TRAVEL_AVIA_COMMON_DICTS_BUNDLE(TRAVEL_DICT_AVIA_BASE):
    """Архив с общими справочниками авиа"""
    resource_name = 'common_dicts'


def is_dict_type_of(entry, dict_type):
    if inspect.isclass(entry) and issubclass(entry, dict_type) and entry != dict_type:
        return True
    return False


def is_rasp_dict(entry):
    return is_dict_type_of(entry, TRAVEL_DICT_RASP_BASE)


def is_avia_dict(entry):
    return is_dict_type_of(entry, TRAVEL_DICT_AVIA_BASE)
