# coding=utf-8

from sandbox.projects.Travel.tasks import TravelBuildBase
from sandbox.projects.common.build import YaMake


class TravelYaMake(TravelBuildBase.TravelBuildBase, YaMake.YaMakeTask):
    type = 'TRAVEL_YA_MAKE'

    input_parameters = YaMake.YaMakeTask.input_parameters + [
        TravelBuildBase.ComponentName,
        TravelBuildBase.CommitMessage,
        TravelBuildBase.Committer,
        TravelBuildBase.Revision,
        TravelBuildBase.DeployEnvironment,
        TravelBuildBase.TravelFilteringTarget,
        TravelBuildBase.CommitPaths,
    ]

    def on_create(self):
        TravelBuildBase.TravelBuildBase.on_create(self)

    def on_enqueue(self):
        YaMake.YaMakeTask.on_enqueue(self)
        TravelBuildBase.TravelBuildBase.on_enqueue(self)

    def on_execute(self):
        targets = YaMake.YaMakeTask.get_targets(self)
        if TravelBuildBase.TravelBuildBase.should_execute(self, make_targets=targets):
            TravelBuildBase.TravelBuildBase.on_execute(self)
            YaMake.YaMakeTask.on_execute(self)

    def on_success(self):
        if TravelBuildBase.TravelBuildBase.was_executed(self):
            YaMake.YaMakeTask.on_success(self)
        TravelBuildBase.TravelBuildBase.on_success(self)

    def on_failure(self):
        if TravelBuildBase.TravelBuildBase.was_executed(self):
            YaMake.YaMakeTask.on_failure(self)
        TravelBuildBase.TravelBuildBase.on_failure(self)

    def on_timeout(self):
        if TravelBuildBase.TravelBuildBase.was_executed(self):
            YaMake.YaMakeTask.on_timeout(self)
        TravelBuildBase.TravelBuildBase.on_timeout(self)

    def on_break(self):
        if TravelBuildBase.TravelBuildBase.was_executed(self):
            YaMake.YaMakeTask.on_break(self)
        TravelBuildBase.TravelBuildBase.on_break(self)

    def on_release(self, additional_parameters):
        TravelBuildBase.TravelBuildBase.before_release(self, additional_parameters)
        YaMake.YaMakeTask.on_release(self, additional_parameters)
        TravelBuildBase.TravelBuildBase.after_release(self, additional_parameters)
